#include "mbed.h"
#include "TurntableControl.h"
#include "ConsoleSerial.h"

#define CONSOLE_BAUD 115200



DigitalOut my_led(LED1); // Sanity LED
TurntableControl tc; // Turntable controller


ConsoleSerial cs(SERIAL_TX, SERIAL_RX);


int main() {
    
    
    cs.setBaud(CONSOLE_BAUD);
    
    cs.printf("resetting\n\r");
    
    // Step 1: reset the turntable
    tc.reset();
    cs.printf("reset\n\rcalibrating\n\r");
    
    // Step 2: calibrate the turntable
    cs.printf("Max encoder = %d\n\r", tc.calibrate());
    
    // Step 3: rotate to a specified quarter
    tc.quarterTurns(4);
    
    cs.printf("Done incrementing\r\n");
    cs.printf("Encoder Current = %d\r\n", tc.getEncoderCurrent());
    
    // Step 4: Include WiConnect Library
    // Step 5: Interpret commands sent over TCP
    
    
    // Configure sanity LED to blink
    while(1) {
        my_led = !my_led;
        wait(0.5);
    }
}
