#pragma once

#include "mbed.h"

class TurntableControl
{
private:
    int encoderMax; // Calibrated maximum value for the encoder
    int encoderCurrent; // Keeps track of the current position of the turn table
    DigitalIn encoder;
    DigitalIn limitSW;
    DigitalOut ttdriver;
public:
    TurntableControl();
    TurntableControl(PinName, PinName, PinName);
    void initialise();
    int calibrate(); // synchronises and calibrates MCU to turntable
    void incrementTurntable(int); // increments value i, used as an interrupt target
    void reset();
    int getEncoderCurrent();
    int getEncoderMax();
    int getEncoder();
    void quarterTurns(int);
};