/**
 * Made by Jurica @ aconno
 * jurica@aconno.de
 * More info @ aconno.de
 */

#include "mbed.h"
#include "aconnoHelpers.h"
#include "ble/BLE.h"
#include "aconnoConfig.h"

#define UPDATE_SENSORS_SIGNAL   (0x10001000)
#define SEND_DATA_SIGNAL        (0x10001001) 
extern Thread updateDataThread;
extern Thread sendDataThread;

void updateDataTask()
{
    //printf("updateDataTask started.\r\n");
    while(1)
    {
        
        ThisThread::flags_wait_any(UPDATE_SENSORS_SIGNAL);
        //printf("Ulazim\r\n");
        updateData();
        sendDataThread.flags_set(SEND_DATA_SIGNAL);
        //printf("Vrtim se.\r\n");
    }
}

void sendDataTask()
{
    //printf("sendDataTask started.\r\n");
    BLE &ble = BLE::Instance();
    while(1)
    {
        updateDataThread.flags_set(UPDATE_SENSORS_SIGNAL);
        ThisThread::flags_wait_any(SEND_DATA_SIGNAL);
        //printf("Turning BLE radion on.\r\n");
        ble.gap().startAdvertising();
        ThisThread::sleep_for(RADIO_ACTIVE_TIME_MS);
        //printf("Turining BLE radio off.\r\n");
        ble.gap().stopAdvertising();
        MBED_ASSERT((ADV_PERIOD_TIME_MS-RADIO_ACTIVE_TIME_MS) > 0);
        ThisThread::sleep_for(ADV_PERIOD_TIME_MS-RADIO_ACTIVE_TIME_MS);
        
    }
}