/* 
 * aconno.de
 * Made by Jurica Resetar
 * Edited by Karlo Milicevic
 * Edited by Dominik Bartolovic
 * All right reserved 
 *
 */

#include "mbed.h"
#include "ble/BLE.h"
#include "acd52832_bsp.h"
#include "GapAdvertisingData.h"
#include "aconnoConfig.h"
#include "Si7006A20.h"
#include "LSM9DS1.h"
#include "adc52832_common/utilities.h"
#include "acd_nrf52_saadc.h"
#include "tasks.h"
#include <events/mbed_events.h>
#include "aconnoHelpers.h"

GapAdvertisingData adv_data = GapAdvertisingData();
advertising_packet advertisementPacket;
DigitalOut lightPower(p28);
DigitalOut temperaturePower(p31);
DigitalOut shdn(p6);
DigitalOut power(p2);

Thread updateDataThread;
Thread sendDataThread;

EventQueue eventQueue;

/**
 * Callback triggered when the ble initialization process has finished
 */
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE &ble = BLE::Instance();

    advertisementPacket.header = APPLICATION_ID;
    /* setup advertising */
    ble.gap().accumulateAdvertisingPayload(
        GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.gap().accumulateAdvertisingPayload(
        GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, 
        (uint8_t *)&advertisementPacket, sizeof(advertisementPacket));
    ble.gap().setAdvertisingType(
        GapAdvertisingParams::ADV_NON_CONNECTABLE_UNDIRECTED);    
    ble.gap().setAdvertisingInterval(ADV_INTERVAL_MS);
    ble.gap().setTxPower(TX_POWER_DB);        // Set TX power to TX_POWER 
}

void scheduleBleEventsProcessing(BLE::OnEventsToProcessCallbackContext* context)
{
    BLE &ble = BLE::Instance();
    eventQueue.call(Callback<void()>(&ble, &BLE::processEvents));
}

int main()
{
    BLE &ble = BLE::Instance();
    ble.init(bleInitComplete);
    ble.onEventsToProcess(scheduleBleEventsProcessing);
    while (ble.hasInitialized()  == false) { /* spin loop */ }
    
    updateDataThread.start(updateDataTask);
    sendDataThread.start(sendDataTask);

    while(true)
    {
        Thread::wait(0xFFFFFFFF);
    }
}
