/**
 * Made by Jurica @ aconno
 * jurica@aconno.com
 * More info @ aconno.de
 */

#ifndef __ACONNO_CONFIG_H__
#define __ACONNO_CONFIG_H__

#define V0                      (0.47)      // In volts 
#define TC                      (0.01)      // In volts 
#define VCC                     (3.6)
#define VALUE_TO_PERCENTAGE     (100)
#define APPLICATION_ID          (0xCF170059)

#define ADC_REFERENCE           (3.6f)      // adc reference voltage 
#define ADC_RESOLUTION          (1024)      // 10-bit adc            
#define CALIBRATION_STEPS       (20)
#define WAKEUP_TIME_DELAY_MS    (150)       // Time for sensors to wake up

#define I2C_DATA                (p19)
#define I2C_CLK                 (p20)
#define SPI_MISO                (p5)
#define SPI_MOSI                (p3)
#define SPI_SCLK                (p4)

#define SENSORS_REFRESH_RATE_MS (1000)      // NOT IN USE!!
// The beacon wakes up every ADV_PERIOD_TIME_MS
#define USER_ADV_PERIOD_TIME_MS (1000-125)
#define ADV_PERIOD_TIME_MS      (USER_ADV_PERIOD_TIME_MS-WAKEUP_TIME_DELAY_MS)      
// The beacon advertises for RADIO_ACTIVE_TIME_MS
#define BLE_PACKETS_TO_SEND     (3)
#define ADV_INTERVAL_MS         (100)        // Adv interval in ms (BLE level!)
#define RADIO_ACTIVE_TIME_MS    (ADV_INTERVAL_MS*BLE_PACKETS_TO_SEND)
#define TX_POWER_DB             (4)

struct __attribute__((packed, aligned(1))) advertising_packet
{
    uint32_t header;
    float degree;
};

#endif  // __ACONNO_CONFIG_H__