/*******************************************************************************
 *  Copyright (C) 2019 Spudware Inc, Inc., All Rights Reserved.
 *  Author: Russell Eldridge, 
 *  swi_core
 *  Date: 10/23/2019
 *  Title: swi core library
 *  Filename: swi_led_hw.cpp
 *  Description:  
 *  Purpose: 
 ******************************************************************************/

#include "mbed.h"
#include "swi_peripherals.h"
#include "swi_led_hw.h"

/*******************************************************************************
   
*******************************************************************************/
void max32620_led_setup(DigitalOut &rLED, DigitalOut &gLED, DigitalOut &bLED)
{
    //  To statically reference these devices anywhere in the application
    Peripherals::set_rLED(&rLED);
    Peripherals::set_gLED(&gLED);
    Peripherals::set_bLED(&bLED);
}  

/*******************************************************************************
 
*******************************************************************************/
void max32620_led_color(int color)
{
    switch(color)
    {
        case mBLACK: /* black */
            Peripherals::rLED()->write(LED_OFF);    
            Peripherals::gLED()->write(LED_OFF);      
            Peripherals::bLED()->write(LED_OFF);   
            break;
        case mRED: /* red */
            Peripherals::rLED()->write(LED_ON);    
            Peripherals::gLED()->write(LED_OFF);      
            Peripherals::bLED()->write(LED_OFF);     
            break;
        case mGREEN: /* grn */
            Peripherals::rLED()->write(LED_OFF);    
            Peripherals::gLED()->write(LED_ON);      
            Peripherals::bLED()->write(LED_OFF);   
            break;
        case mBLUE: /* blu */
            Peripherals::rLED()->write(LED_OFF);    
            Peripherals::gLED()->write(LED_OFF);      
            Peripherals::bLED()->write(LED_ON);   
            break;
        case mYELLOW: /* yel */
            Peripherals::rLED()->write(LED_ON);    
            Peripherals::gLED()->write(LED_ON);      
            Peripherals::bLED()->write(LED_OFF);   
            break;
        case mCYAN: /* cya */
            Peripherals::rLED()->write(LED_OFF);    
            Peripherals::gLED()->write(LED_ON);      
            Peripherals::bLED()->write(LED_ON);   
            break;
        case mVIOLET: /* vio */
            Peripherals::rLED()->write(LED_ON);    
            Peripherals::gLED()->write(LED_OFF);      
            Peripherals::bLED()->write(LED_ON);   
            break;
        case mWHITE: /* white */
            Peripherals::rLED()->write(LED_ON);    
            Peripherals::gLED()->write(LED_ON);      
            Peripherals::bLED()->write(LED_ON);   
            break;
        default:  
            break;
    }   
}  