# Getting started with the USB serial test on mbed OS

This guide reviews the steps required to get the firmware working on an mbed OS platform.

Please install [mbed CLI](https://github.com/ARMmbed/mbed-cli#installing-mbed-cli).


## Import the example application

From the command-line, import the example:

```
mbed import mbed-os-usbserial-test
cd mbed-os-usbserial-test
```


### Now compile

Invoke `mbed compile`, and specify the name of your platform and your favorite
toolchain (`GCC_ARM`, `ARM`, `IAR`). For example, for the Bluepill STM32F103C8
and the GNU C compiler :

```
mbed compile -m BLUEPILL_F103C8 -t GCC_ARM
```

Your PC may take a few minutes to compile your code. At the end, you see the
some statistics about the compiled firmware.

```
[TBD]
```


### Program your board

Connections:

    ST-Link V2  STM32F103 (blue pill) SWD connector
    GND         GND
    SWCLK       SWCLK (PA14)
    SWDIO       SWDIO (PA13)
    3V3         3V3

Flash firmware:

    st-flash --reset write ./BUILD/NUCLEO_F103RB/GCC_ARM/*.bin 0x8000000


## Connect

Connect your board via USB and start a serial terminal application:

    miniterm /dev/ttyACM0 115200


## References

If you have problems, please review the [documentation](https://os.mbed.com/docs).

* https://os.mbed.com/users/hudakz/code/USBDevice_STM32F103/
* https://os.mbed.com/users/hudakz/code/STM32F103C8T6_USBSerial/
* http://wiki.stm32duino.com/index.php?title=Blue_Pill