/* FXOS8700Q Example Program
 * Copyright (c) 2014-2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "FXOS8700Q.h"
#include "EthernetInterface.h"
#include "Websocket.h"

Serial pc(USBTX, USBRX);
I2C i2c(PTE25, PTE24);

FXOS8700QAccelerometer acc(i2c, FXOS8700CQ_SLAVE_ADDR1);    // Configured for the FRDM-K64F with onboard sensors
FXOS8700QMagnetometer mag(i2c, FXOS8700CQ_SLAVE_ADDR1);


int main(void)
{

    float faX, faY, faZ, fmX, fmY, fmZ;
    
    //Ethernet Interface
    EthernetInterface eth;
    eth.init();
    eth.connect();
    printf("IP Address is %s\n\r", eth.getIPAddress());
    
    //Sockets
    Websocket ws("ws://node-red-spookmx.c9.io/ws/inputs");
    ws.connect();
    
    acc.enable();
    mag.enable();
    ws.send("{'success':true, 'payload':'Starting Socket TX'}");
    printf("{'success':true, 'payload':'Starting Socket TX'}\n\r");
    while (true) {
        acc.getX(faX);
        acc.getY(faY);
        acc.getZ(faZ);
        mag.getX(fmX);
        mag.getY(fmY);
        mag.getZ(fmZ);
        char output[500];
        snprintf(output,500,"ACC: X=%1.4ff Y=%1.4ff Z=%1.4ff \t MAG: X=%4.1ff Y=%4.1ff Z=%4.1ff\r\n", faX, faY, faZ, fmX, fmY, fmZ);
        printf("ACC: X=%1.4ff Y=%1.4ff Z=%1.4ff \t MAG: X=%4.1ff Y=%4.1ff Z=%4.1ff\r\n", faX, faY, faZ, fmX, fmY, fmZ);
        ws.send(output);
        puts("");
        //wait(5.0f);
    }
}