#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

EthernetInterface eth;
HTTPClient http;
char str[512];

DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
DigitalOut led_blue(LED_BLUE);
Serial pc(USBTX, USBRX);

void check_color(void)
{
    //GET data
    printf("\nTrying to fetch page...\n");
    int ret = http.get("http://joseromero.mx/checkColor.php", str, 128);
    if (!ret) {
        if(strcmp(str," RED")== 0) {
            led_green = 1;
            led_red = 0;
            led_blue = 1;
        } else if(strcmp(str," GREEN")== 0) {
            led_green = 0;
            led_red = 1;
            led_blue = 1;
        } else if(strcmp(str," BLUE")== 0) {
            led_green = 1;
            led_red = 1;
            led_blue = 0;
        } else {
            led_green = 0;
            led_red = 0;
            led_blue = 1;
        }
        printf("Page fetched successfully - read %d characters\n", strlen(str));
        printf("Result: %s\n", str);
    } else {
        printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
}


int main()
{
    eth.init(); //Use DHCP
    eth.connect();

    led_green = 1;
    led_red = 1;
    led_blue = 1;
    pc.printf("Starting setting color.\n");
    while (true) {
        check_color();
        wait(2);
    }
}
