#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

EthernetInterface eth;
HTTPClient http;
char str[512];

// FRDM17511 I/O
DigitalOut ENABLED(PTC7);
DigitalOut READY(PTC5);
DigitalOut OUT1(D2); 
DigitalOut OUT2(D3);
DigitalIn SNS(PTC0);

// LED
DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
DigitalOut led_blue(LED_BLUE);
Serial pc(USBTX, USBRX);

void check_color(void)
{
    //GET data
    printf("\nTrying to fetch page...\n");
    int ret = http.get("http://iot.freescale.com/components/com_ohanah/checkColor.php", str, 128);
    if (!ret) {
        if(strcmp(str,"AUTHORIZED")== 0) {
            led_green = 1;
            led_red = 1;
            led_blue = 0; // Found new tweet, we turn the led to blue
            OUT1 = 1;
            OUT2 = 0;
            wait(3); // Leaves the motor ON for 3 seconds
            OUT1 = 0; // We turn it off
            OUT2 = 0;
            led_green = 0; // We go back to green light
            led_red = 1;
            led_blue = 1;
        } else if(strcmp(str,"NOT AUTHORIZED")== 0) {
            led_green = 1;
            led_red = 0; // No new tweets, RED light
            led_blue = 1;
            wait(3);
            led_green = 0; // We go back to green light
            led_red = 1;
            led_blue = 1;
        } else if(strcmp(str,"NO DATA")== 0) {
            led_green = 1;
            led_red = 0; // No data from the server, goes to PURPLE
            led_blue = 0;
            wait(3);
            led_green = 0; // We go back to green light
            led_red = 1;
            led_blue = 1;
        } else {
            led_green = 0; // If the server provides a different response go to YELLOW, check server side code.
            led_red = 0;
            led_blue = 1;
        }
        printf("Page fetched successfully - read %d characters\n", strlen(str));
        printf("Result: %s\n", str);
    } else {
        printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
}


int main()
{
    eth.init(); //Use DHCP
    eth.connect();
    led_green = 0;
    led_red = 1;
    led_blue = 1;
    ENABLED = 1;
    READY = 1;
    
    while (true) {
        check_color();
        wait(5); // Check for a tweet every 5 seconds
    }
}
