#include "mbed.h"
#include "COMPASS_DISCO_L476VG.h"
#include "LCD_DISCO_L476VG.h"
#define USE_PRINTF (1)

uint32_t temp = 0;
uint8_t stemp[7] = {0};

LCD_DISCO_L476VG lcd;
COMPASS_DISCO_L476VG compass;
// LEDs
DigitalOut led_green(LED1);
DigitalOut led_red(LED2);

DigitalOut led1(LED1);

// Joystick button
InterruptIn center(JOYSTICK_CENTER);
InterruptIn left(JOYSTICK_LEFT);
InterruptIn right(JOYSTICK_RIGHT);
InterruptIn up(JOYSTICK_UP);
InterruptIn down(JOYSTICK_DOWN);

int16_t MagBuffer_Global[3];
int16_t AccBuffer_Global[3];
    
void center_released() {
    led_green = 0;
    lcd.Clear();
#if USE_PRINTF == 1
    printf("center button released\n");
#endif  
}


void center_pressed() {
        sprintf((char *)stemp, "X = %d\n", MagBuffer_Global[0]);
        lcd.DisplayString(stemp);
        //lcd.DisplayString((uint8_t *)"CENTER");
#if USE_PRINTF == 1  
    printf("center button pressed\n");
#endif  
BSP_COMPASS_DeInit();
BSP_COMPASS_Init();
}

void left_released() {
    led_green = 0;
    lcd.Clear();
#if USE_PRINTF == 1
    printf("left button released\n");
#endif  
}

void left_pressed() {
    sprintf((char *)stemp, "Y = %d\n", MagBuffer_Global[0]);
        lcd.DisplayString(stemp);
        //lcd.DisplayString((uint8_t *)"LEFT");
   
#if USE_PRINTF == 1  
    printf("left button pressed\n");
#endif  
}

void right_released() {
    led_green = 0;
    lcd.Clear();
#if USE_PRINTF == 1
    printf("right button released\n");
#endif  
}

void right_pressed() {
    sprintf((char *)stemp, "Z = %d\n", MagBuffer_Global[0]);
        lcd.DisplayString(stemp);
        //lcd.DisplayString((uint8_t *)"RIGHT");
    led_green = 1;
#if USE_PRINTF == 1  
    printf("right button pressed\n");
#endif  
}

void up_released() {
    led_green = 0;
    lcd.Clear();
#if USE_PRINTF == 1
    printf("up button released\n");
#endif  
}

void up_pressed() {
    sprintf((char *)stemp, "X = %d\n", AccBuffer_Global[0]);
        lcd.DisplayString(stemp);
        //lcd.DisplayString((uint8_t *)"UP");
    led_green = 1;
#if USE_PRINTF == 1  
    printf("up button pressed\n");
#endif  
}

void down_released() {
    led_green = 0;
    lcd.Clear();
#if USE_PRINTF == 1
    printf("down button released\n");
#endif  
}

void down_pressed() {
    sprintf((char *)stemp, "Z = %d\n", AccBuffer_Global[0]);
        lcd.DisplayString(stemp);
        //lcd.DisplayString((uint8_t *)"DOWN");
    led_green = 1;
#if USE_PRINTF == 1  
    printf("down button pressed\n");
#endif  
}
    
int main()
{
    int16_t MagBuffer[3];
    int16_t AccBuffer[3];
    
  
    printf("Compass started\n");
    lcd.DisplayString((uint8_t *)"HELLO");
      // Both rise and fall edges generate an interrupt
    center.fall(&center_released);
    center.rise(&center_pressed);
    left.fall(&left_released);
    left.rise(&left_pressed);
    right.fall(&right_released);
    right.rise(&right_pressed);
    up.fall(&up_released);
    up.rise(&up_pressed);
    down.fall(&down_released);
    down.rise(&down_pressed);

    // Add pull-down on these pins
    // Warning: must be done AFTER edges setting
    left.mode(PullDown);
    right.mode(PullDown);
    up.mode(PullDown);
    down.mode(PullDown);
  
    while(1) {
      
        // Read acceleremoter and magnetometer values
        compass.AccGetXYZ(AccBuffer);
        compass.MagGetXYZ(MagBuffer);
        MagBuffer_Global[0]= MagBuffer[0];
        AccBuffer_Global[0]= AccBuffer[0];
        // Display values      
        printf("Acc X = %d\n\r", AccBuffer[0]);
        //AccBuffer[1]=0;
        //AccBuffer[2]=0;
        printf("Acc Y = %d\n\r", AccBuffer[1]);
        printf("Acc Z = %d\n\r", AccBuffer[2]);
        //MagBuffer[1]=0;
        //MagBuffer[2]=0;
        printf("Mag X = %d\n\r ", MagBuffer[0]);
        printf("Mag Y = %d ", MagBuffer[1]);
        printf("Mag Z = %d\n\r", MagBuffer[2]);
        printf("\033[6A"); // Moves cursor up x lines (x value is between [ and A)
      
        led1 = !led1;
        wait(2);
    }
}

    
