/*
Author: Philippe Spino (spip2401)
CoAuthor: Jacob Fontaine (fonj1903)
This program is a midware for managing data for end points of a smart doorbell system.
This is the main loop. This program uses the Xbee lib to ease the transfert of data from Warden to EndPoints and vice-versa.
*/
#include "mbed.h"
#include "XBeeLib.h"

#include "Websocket.h"
#include "EthernetInterface.h"

using namespace std;
using namespace XBeeLib;

Serial pc(USBTX,USBRX);
uint8_t lensFrame[121] = {0};
void nodeDiscovery(const RemoteXBeeZB& remote, char const * const node_id)
{
    pc.printf("Found device '%s'\r\n", node_id);
}

void receiveImage(const RemoteXBeeZB& remote, bool broadcast, const uint8_t *const data, uint16_t len)
{
    pc.printf("%d",len);
    for(uint8_t index =0;index<len;index++)
    {
        lensFrame[index] = data[index];
    }
    for(uint8_t i =0;i<121;i++)
    {
        pc.printf("%d",lensFrame[i]);
    }
}    
int main() 
{
    bool exit = false;
    //char URL[25] = "ws://192.168.137.1:8000/";
    //Building coordinator.
    pc.printf("XBee Coordinator Setup\n");
    XBeeZB xbee(p13,p14,p8,NC,NC,9600);
    RadioStatus status = xbee.init();
    xbee.set_panid(0x6969);
    pc.printf("XBee init done\n");
    pc.printf("Discovering...\n");
    xbee.register_node_discovery_cb(&nodeDiscovery);
    xbee.register_receive_cb(&receiveImage);
    xbee.config_node_discovery(1000,true);              //setting the timeout to 1000ms and enabling the auto-discovery.
    xbee.start_node_discovery();
    do{
        xbee.process_rx_frames();
        wait_ms(100);
        pc.printf(".");
    }while(xbee.is_node_discovery_in_progress());
    pc.printf("Node discovery is done\n");
    
    pc.printf("Connecting Ethernet to server...\n");
    EthernetInterface eth;
    eth.set_network("169.254.161.92","255.255.0.0","10.238.32.1");
    eth.connect();
    
    pc.printf("IP Address is : %s\n", eth.get_ip_address());
    pc.printf("Creating socket...\n");
    
    //Connecting to server via websocket with static address. Address is bound to Warden.
    bool retry = false;
    Websocket socket("ws://169.254.161.92:8000/", &eth);
    pc.printf("Connecting...\n");
    while(!socket.connect())
        pc.printf(".");
    pc.printf("\nConnected!\n");
    
    while(exit == false)
    {
        
        char xbeeSendBuffer[202]            = "";           //202 is max buffer size for Xbee.
        char xbeeReadBuffer[202]            = "";
        char wardenHeaderBuffer[200];
        char wardenValueBuffer[200];
        char wardenSendBuffer[200];
        bool deliverToXbee = false;
        bool deliverToWarden = false;
        
        //Verify if the xbee has a message in the buffer.
        
        if(xbeeReadBuffer[0] != '\0')           /*Need to verify if the null char is the right char to compare when no data is recieved.*/
        {
            /*We need to define what is comming from vault and what is comming from eyelens.
                Best option now is to send a string with specific characters and then do a
                switch/case with the formated string. */
            int data = atoi(xbeeReadBuffer);
            switch(data)
            {
                case 0x56544F4C:        //VTOL(Vault Open Lock cmd)
                {
                    pc.printf("Opening Vault's Lock\n");
                    sprintf(wardenSendBuffer,"Vault's Lock is Open");
                }
                case 0x5654434C:        //VTCL(Vault Close Lock cmd)
                {
                    pc.printf("Closing Vault's Lock\n");
                }
                case 0x5654454C:        //VTEL(Vault Error Lock cmd)
                {
                    pc.printf("There is an error with the lock");
                }
                case 0x454C5650:        //ELVP(Eyelen video packet cmd)
                {
                    pc.printf("Incomming video Packet from Lens\n");
                }
                case 0x454C5644:        //ELVD(Eyelen video detection cmd)
                {
                    pc.printf("Incomming video detection from Lens\n");
                }
                case 0x454C4944:        //ELID(Eyelen ID cmd)
                {
                    pc.printf("Recieving Eyelen mbed's ID\n");
                }
                default:                //Not a command....
                {
                    pc.printf("Unknownd message from router\n");
                }
                deliverToWarden = true;
            }
        }
        
        //Verify if warden has a command for end devices.
        if(wardenHeaderBuffer != "\0" && wardenValueBuffer != "\0")
        {
            /*We need to define how the command will be sent and how a command will be written.
            Best option now is to send a string with specific characters and then do a
            switch/case with the formated string. */
            if(wardenHeaderBuffer == "HelloWorld"){
                pc.printf("HelloWorld");
            }
            else if(wardenHeaderBuffer == "Lock")
            {
                if(wardenValueBuffer == "open")
                   sprintf(xbeeSendBuffer, "VTOL");
                else
                   sprintf(xbeeSendBuffer, "VTCL");
            }
        }
        
        if(deliverToXbee){
        }
    }
}