#include "mbed.h"
#include "Barometer.h"
#include "LocalFileSystem.h"
#include "math.h"
#include "Servo.h"

Serial pc(USBTX, USBRX);
Timer end;
int stat=1;

////////////////////////////////////
//         GPS         5V p27(RX) //  
//      Bluetooth    3.3V p28(TX) //
////////////////////////////////////
Serial Blue_GPS(p28, p27);

char GPS_msg[2000], ns, ew;
int i = 0, j=0, k=0, gps_ok=0, GPS_flag;
volatile unsigned char GPS_buffer[2];
float fix,sat,x,longitude=0.0f,latitude=0.0f, alt_GPS=0,lock, Kor_time;
int blue_ok=0;

void GPS_isr(){
    while(Blue_GPS.readable()){
        i++;
        GPS_buffer[1] = GPS_buffer[0];
        GPS_buffer[0] = Blue_GPS.getc();
        if ((GPS_buffer[1]==13)&(GPS_buffer[0]==10)){   
            i=0;
            if (GPS_flag == 1){GPS_flag = 0; gps_ok = 1; j=0;}
        }
        if ((i==5)&(GPS_buffer[0] == 'G')){GPS_flag=1;}
        if (GPS_flag==1){GPS_msg[j]=GPS_buffer[0]; j++; pc.printf("%d \r\n", j);}
    }

    //Blue_GPS.printf("");
}

float trunc(float v) {
    if(v < 0.0) {
        v*= -1.0;
        v = floor(v);
        v*=-1.0;
    }
    else {v = floor(v);}
    return v;
}

void get_GPS(float *Kor_time, float *latitude, char *ns, float *longitude, char *ew, float *fix, float *sat, float *x, float *alt_GPS, float *lock)
{
    if (gps_ok == 1){
        gps_ok = 0;
        sscanf(GPS_msg, "GA,%f,%f,%c,%f,%c,%f,%f,%f,%f,%f", Kor_time,latitude,ns,longitude,ew,fix,sat,x,alt_GPS,lock);
        if(*ns == 'S') {*latitude  *= -1.0; }
        if(*ew == 'W') {*longitude *= -1.0; }
        float degrees = trunc(*latitude / 100.0f);
        float minutes = (*latitude - (degrees * 100.0f));
        *latitude = degrees + minutes / 60.0f;    
        degrees = trunc(*longitude / 100.0f);
        minutes = *longitude - (degrees * 100.0f);
        *longitude = degrees + minutes / 60.0f;
        *Kor_time = *Kor_time + 90000;
    }
}

//Bluetooth code is placed under the Log_data

////////////////////////////////////////////
//    Barometer     3.3V p9(SDA) p10(SCL) //  
////////////////////////////////////////////
Barometer barometer(p9, p10);
float t, alt, del_alt;
float alt_sum=0.0f, alt_zero=0.0f;
int count = 0, baro_ok = 0;          // for zero-calibration
float alt_buffer[4], w_alt=0.6;          // weight for LPF

void get_Baro(float*t, float*alt, float*del_alt)
{   
    if (baro_ok==1){
    barometer.update();
    *t = barometer.get_temperature();
    *alt = barometer.get_altitude_m();
    alt_buffer[1] = alt_buffer[0];
    alt_buffer[0] = *alt;
    *alt = w_alt*alt_buffer[1]+(1-w_alt)*alt_buffer[0];  // Low Pass Filter 
    alt_buffer[3] = alt_buffer[2];
    alt_buffer[2] = *alt;
    *del_alt = alt_buffer[3]-alt_buffer[2];      // for calculation of drop speed
    baro_ok = 0;
    }
} 

void calb_alt(){
    if (alt==0){}
    else {
        if (count<=19){alt_sum = alt_sum + alt; count++;}
        else {
            Blue_GPS.printf("calibration\r\n");
            alt_zero = alt_sum / (float)count;
            count++;
        }
    }
}
/*
void lpf_alt(){
    alt_buffer[1] = alt_buffer[0];
    alt_buffer[0] = alt;
    alt = w_alt*alt_buffer[1]+(1-w_alt)*alt_buffer[0];  // Low Pass Filter 
    alt_buffer[3] = alt_buffer[2];
    alt_buffer[2] = alt;
    del_alt = alt_buffer[3]-alt_buffer[2];      // for calculation of drop speed
}
*/
///////////////////////////////////////
//         AHRS          5V p14(RX)  //   20Hz
///////////////////////////////////////
Serial AHRS(p13, p14);
float roll,pitch,yaw,accx,accy,accz;
char AHRS_msg[150];
int m=0, ahrs_ok=0, AHRS_flag;
volatile unsigned char AHRS_buffer[2];
float roll_buffer[2], pitch_buffer[2], yaw_buffer[2], w_attitude=0.8;

void AHRS_isr(){                      //inturupt 
    while(AHRS.readable()){
        AHRS_buffer[1] = AHRS_buffer[0];
        AHRS_buffer[0] = AHRS.getc();
        if (AHRS_buffer[0] == '\n' && AHRS_flag == 1){AHRS_flag = 0; ahrs_ok = 1; m=0;}
        if (AHRS_buffer[0] == '*'){AHRS_flag=1;}
        if (AHRS_flag==1){AHRS_msg[m] = AHRS_buffer[0]; m++;}
    }
} 

void get_AHRS(float*roll, float*pitch, float*yaw, float*accx, float*accy, float*accz)
{
    if (ahrs_ok == 1){
        ahrs_ok = 0;
        sscanf(AHRS_msg, "*%f,%f,%f,%f,%f,%f\n", roll, pitch, yaw, accx, accy, accz);
        roll_buffer[1] = roll_buffer[0];
        roll_buffer[0] = *roll;
        *roll = w_attitude*roll_buffer[1]+(1-w_attitude)*roll_buffer[0];  // Low Pass Filter 
        pitch_buffer[1] = pitch_buffer[0];
        pitch_buffer[0] = *pitch;
        *pitch = w_attitude*pitch_buffer[1]+(1-w_attitude)*pitch_buffer[0];  // Low Pass Filter 
        yaw_buffer[1] = yaw_buffer[0];
        yaw_buffer[0] = *yaw;
        *yaw = w_attitude*yaw_buffer[1]+(1-w_attitude)*yaw_buffer[0];  // Low Pass Filter 
        baro_ok = 1;
        blue_ok = 1;
    }
} 
/*
void lpf_attitude(){
    roll_buffer[1] = roll_buffer[0];
    roll_buffer[0] = roll;
    roll = w_attitude*roll_buffer[1]+(1-w_attitude)*roll_buffer[0];  // Low Pass Filter 
    pitch_buffer[1] = pitch_buffer[0];
    pitch_buffer[0] = pitch;
    pitch = w_attitude*pitch_buffer[1]+(1-w_attitude)*pitch_buffer[0];  // Low Pass Filter 
    yaw_buffer[1] = yaw_buffer[0];
    yaw_buffer[0] = yaw;
    yaw = w_attitude*yaw_buffer[1]+(1-w_attitude)*yaw_buffer[0];  // Low Pass Filter 
}
*/

///////////////////////////////////
//      Servo         5V  PWM    //
///////////////////////////////////
Servo Micro_gf(p22);

float unf_value=1.0, gf_value = 0.35,linear_value = 1.0;
float tg_yaw = 0.0, err_yaw = 0.0, p=1.5;
void ctl_gf(){
    err_yaw = yaw - tg_yaw;
    gf_value = 0.35*exp(0.0039*p*err_yaw);
    if (err_yaw<0){gf_value = 0.7-0.35*exp(0.0039*p*(-err_yaw));}
    if (gf_value<=0.0){gf_value=0.0;}
    else if (gf_value>=0.7) {gf_value=0.7;}
    Micro_gf = gf_value;
}

///////////////////////////////
//   Datalogger       Mbed   //
///////////////////////////////
LocalFileSystem local("local");
int file_no=1;
char filename[256];
FILE *fp;

void Log_file(){
    sprintf(filename, "/local/Data%d.txt", file_no); //save file name for writing
    fp = fopen(filename, "r"); // if file can be loaded, return is 1
    while(fp){
        fclose(fp);
        file_no ++;
        sprintf(filename, "/local/Data%d.txt", file_no);    // Open "tem%d.txt" on the local file system for writing
        fp = fopen(filename, "r");
    }
    fp = fopen(filename, "w");    
}

void Log_data(){
    fprintf(fp, "%i,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f\r\n",stat,Kor_time,latitude,longitude,alt,alt_GPS,roll,pitch,yaw,accx,accy,accz,unf_value,gf_value,linear_value);
}

void send_Blue(){
    if (blue_ok == 1){
    blue_ok = 0;
    Blue_GPS.printf("%i,%.0f,%.6f,%.6f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f\r\n",stat,Kor_time,latitude,longitude,alt,del_alt,roll,pitch,yaw,accz,unf_value,gf_value,linear_value);
    }
}
void send_PC(){
    pc.printf("%i,%.0f,%.6f,%.6f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f\r\n",stat,Kor_time,latitude,longitude,alt,del_alt,roll,pitch,yaw,accz,unf_value,gf_value,linear_value);
}

Ticker timer1;
Ticker timer2;
bool gpsFlag    = 0;
bool blueFlag   = 0;
void timer1_isr(){
    gpsFlag = 1; 
}
void timer2_isr(){
    blueFlag = 1; 
}
/////////////////////////////////
//         Main loop           //
/////////////////////////////////

int main(void)
{   
    AHRS.baud(9600);
    Blue_GPS.baud(9600);
    
    while(Blue_GPS.readable()){
        volatile unsigned char temp = Blue_GPS.getc();
    }
    Blue_GPS.printf("Buffer flushing\r\n");
    
    Blue_GPS.attach(&GPS_isr, Serial::RxIrq);
    AHRS.attach(&AHRS_isr, Serial::RxIrq);
    Blue_GPS.printf("Start\r\n");
    //Log_file();
    timer1.attach(&timer1_isr, 1.0);
    timer2.attach(&timer2_isr, 0.1);
    gf_value = 0.7;
    Micro_gf = gf_value;
        while(1) {
        switch(stat){
            case 1 : //Calibration
                if(gpsFlag)
                {
                    get_GPS(&Kor_time,&latitude,&ns,&longitude,&ew,&fix,&sat,&x,&alt_GPS,&lock);
                    Blue_GPS.printf("getGPS\r\n");
                    gpsFlag = 0;
                }
                if(blueFlag)
                {
                    get_AHRS(&roll,&pitch,&yaw,&accx,&accy,&accz);
                    get_Baro(&t, &alt, &del_alt);
                    calb_alt();
                    Blue_GPS.printf("%i,%.2f,%.2f,%.2f\r\n",count, alt, alt_sum, alt_zero);
                    blueFlag = 0;
                }
                if (20<count) {
                    stat=2;
                }
                break;
            case 2 : //Wait
                if(gpsFlag)
                {
                    get_GPS(&Kor_time,&latitude,&ns,&longitude,&ew,&fix,&sat,&x,&alt_GPS,&lock);
                    gpsFlag = 0;
                } 
                
                if(blueFlag)
                {
                    get_AHRS(&roll,&pitch,&yaw,&accx,&accy,&accz);
                    get_Baro(&t, &alt, &del_alt);
                    //Log_data();
                    alt = alt - alt_zero;
                    send_Blue();
                    send_PC();
                    blueFlag = 0;
                }
                if (alt<=-10 && abs(accx)<0.1 && abs(accy)<0.1){
                    //fclose(fp); 
                    stat=3; send_Blue();
                }
                break;
            /*case 3 :  //Drop
                get_GPS(&Kor_time,&latitude,&ns,&longitude,&ew,&fix,&sat,&x,&alt_GPS,&lock);
                get_AHRS(&roll,&pitch,&yaw,&accx,&accy,&accz);
                get_Baro(&t, &alt);
                //Log_data();
                lpf_alt();
                alt = alt - alt_zero;
                lpf_attitude();
                send_Blue();
                pc.printf("%i,%.2f,%.2f,%.2f,%.2f,%.2f,%.2,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f\r\n",stat,Kor_time,latitude,longitude,alt,alt_GPS,del_alt,roll,pitch,yaw,accx,accy,accz,unf_value,gf_value,linear_value);
                if (alt<=5 && abs(accx)<0.1 && abs(accy)<0.1) {end.start(); stat=4;}
                break;
            case 4 :  //Landing
                get_AHRS(&roll,&pitch,&yaw,&accx,&accy,&accz);
                get_Baro(&t, &alt);
                get_GPS(&Kor_time,&latitude,&ns,&longitude,&ew,&fix,&sat,&x,&alt_GPS,&lock);
                //Log_data();
                lpf_alt();
                alt = alt - alt_zero;
                lpf_attitude();
                send_Blue();
                end.read();
                pc.printf("%i,%.2f,%.2f,%.2f,%.2f,%.2f,%.2,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f\r\n",stat,Kor_time,latitude,longitude,alt,alt_GPS,del_alt,roll,pitch,yaw,accx,accy,accz,unf_value,gf_value,linear_value);
                if (end.read()>=10) {fclose(fp);}
                break;*/
            case 3 :   //Shut down
                break;
        }
    }
}