#ifndef Barometer_H
#define Barometer_H
#include "mbed.h"
 

enum Barometer_oss {
    Barometer_oss1 = 0, ///< ultra low power (1 time)
    Barometer_oss2 = 1, ///< standard (2 times)
    Barometer_oss4 = 2, ///< high resolution (4 times)
    Barometer_oss8 = 3  ///< ultra high resolution (8 times)
};
 

class Barometer {
public:
    Barometer(PinName p_sda, PinName p_scl, Barometer_oss p_oss = Barometer_oss1);
    Barometer(I2C& p_i2c, Barometer_oss p_oss = Barometer_oss1);
 
    float get_temperature();
    float get_pressure();
    void update();
 
protected:
    void init(Barometer_oss);
    unsigned short twi_readshort (int, int);
    unsigned long twi_readlong (int, int);
    void twi_writechar (int, int, int);
 
    I2C i2c;
    float temperature;
    float pressure;
 
private:
 
    short ac1, ac2, ac3, b1, b2, mb, mc, md, oss;
    unsigned short ac4, ac5, ac6;
};
 
#endif