#include "mbed.h"
#include "Barometer.h"
#include "LocalFileSystem.h"
#include "math.h"
#include "Servo.h"
#define dt 0.1
#define FLOT(number) ((float)(int)(number * 100))/100

Serial pc(USBTX, USBRX);
Ticker blue_trig;
Timer t;
float msec = 0.0f;

////////////////////////////////////////
//   Bluetooth    3.3V p13 p14(TX,RX) //
////////////////////////////////////////
Serial Blue(p13, p14);
int send_ok=0;
char Blue_msg[150];
int k=0, Blue_ok=0, Blue_flag=0;
volatile unsigned char Blue_buffer[2];
float input_roll, input_pitch, input_yaw, kP=1.0, kD=3.0;

void Blue_isr(){                      //inturupt 
    while(Blue.readable()){
        Blue_buffer[1] = Blue_buffer[0];
        Blue_buffer[0] = Blue.getc();
        if (Blue_buffer[0] == '\n' && Blue_flag == 1){Blue_flag = 0; Blue_ok = 1; k=0;}
        if (Blue_buffer[0] == '*'){Blue_flag=1;}
        if (Blue_flag==1){Blue_msg[k] = Blue_buffer[0]; k++;}
    }
} 

void get_Blue(float*input_roll, float*input_pitch, float*input_yaw, float*kP, float*kD)
{
    if (Blue_ok == 1){
        Blue_ok = 0;
        sscanf(Blue_msg, "*%f,%f,%f,%f,%f\n", input_roll, input_pitch, input_yaw, kP, kD);
    }
} 

void blue_trig_isr(){
    send_ok=1;   
}

void trans_blue_data(float in_data, int integer_point, int under_point){  // number of intefer and under_point
        unsigned int conv_trans_data;
        conv_trans_data = (unsigned int)abs(in_data * pow((float)10,under_point));
        if(in_data<0) {while((LPC_UART1->LSR&0x20)==0); LPC_UART1->THR = '-';}
        else {while((LPC_UART1->LSR&0x20)==0); LPC_UART1->THR = '+';}
        for(int cnt_num=(integer_point + under_point); cnt_num > 0; cnt_num--){
            if(cnt_num == under_point) {while((LPC_UART1->LSR&0x20)==0); LPC_UART1->THR = '.';   }        
            while((LPC_UART1->LSR&0x20)==0); LPC_UART1->THR = (unsigned char)(conv_trans_data%(unsigned int)(pow((float)10,cnt_num))/(pow((float)10,cnt_num-1)) + 48);       //convert to ASCII    
        }
}

//Bluetooth code is placed under the Log_data

////////////////////////////////////////////
//    Barometer     3.3V p9(SDA) p10(SCL) //  
////////////////////////////////////////////
Barometer barometer(p9, p10);
float alt=0.0;
float alt_sum=0.0f, alt_zero=0.0f;
int count = 0, baro_ok = 0;          // for zero-calibration
float alt_buffer[2], w_alt=0;          // weight for LPF

void get_Baro(float*alt)
{   
    if (baro_ok==1){
        barometer.update();
        *alt = barometer.get_altitude_m();
        alt_buffer[1] = alt_buffer[0]; 
        alt_buffer[0] = *alt;
        if(abs(alt_buffer[0]- alt_buffer[1])>20){
            *alt = alt_buffer[1];
            baro_ok = 0;
        }
        else{
            baro_ok = 0;
        }
    }
} 

void calb_alt(){
    if (alt==0){count=0;}
    else {
        if (count==1){count++;}
        else{
            if (count<=99){alt_sum = alt_sum + alt; count++;}
            else {alt_zero = alt_sum/(float)(count-1); count++;}
        }
    }
}

///////////////////////////////////////
//         AHRS          5V p27(RX)  //   20Hz
///////////////////////////////////////
Serial AHRS(p28, p27);
float roll,pitch,yaw,velx,vely,velz,velxyz, init_roll, init_pitch, q1,q2,q3,q4;
char AHRS_msg[150];
int m=0, ahrs_ok=0, AHRS_flag=0;
volatile unsigned char AHRS_buffer[2];


void AHRS_isr(){                      //inturupt 
    while(AHRS.readable()){
        AHRS_buffer[1] = AHRS_buffer[0];
        AHRS_buffer[0] = AHRS.getc();
        if (AHRS_buffer[0] == '\n' && AHRS_flag == 1){AHRS_flag = 0; ahrs_ok = 1; m=0;}
        if (AHRS_buffer[0] == '*'){AHRS_flag=1;}
        if (AHRS_flag==1){AHRS_msg[m] = AHRS_buffer[0]; m++;}
    }
} 

void get_AHRS(float*roll, float*pitch, float*yaw, float*velx, float*vely, float*velz, float*velxyz)
{
    if (ahrs_ok == 1){
        ahrs_ok = 0;
        sscanf(AHRS_msg, "*%f,%f,%f,%f,%f,%f \n", roll, pitch, yaw, velx, vely, velz);
        *velxyz = (float)sqrt(pow(*velx,2)+pow(*vely,2)+pow(*velz,2));
        baro_ok = 1;
    }
} 

///////////////////////////////////
//      Servo         5V  PWM    // needed to check pin#
///////////////////////////////////
Servo Throttle(p26);
Servo Ctrl_1(p25); //below
Servo Ctrl_2(p23); //upper
Servo Ctrl_3(p22); //below
Servo Ctrl_4(p21); //upper

float thr_value = 0.0, ctrl1_value = 0.5, ctrl2_value = 0.5, ctrl3_value = 0.5, ctrl4_value = 0.5;
float err_roll = 0.0, err_pitch = 0.0, err_yaw = 0.0, err_alt = 0.0, preerror_roll = 0.0, preerror_pitch = 0.0, preerror_yaw = 0.0;
float ctrl_roll = 0.0, ctrl_pitch = 0.0, ctrl_yaw = 0.0;

void ctrl_attitude(){
    err_roll = input_roll - roll;
    err_pitch = input_pitch - pitch;
    err_yaw = input_yaw - yaw;
    ctrl_roll = (kP*err_roll)+(kD*(err_roll-preerror_roll)/dt);
    ctrl_pitch = (kP*err_pitch)+(kD*(err_pitch-preerror_pitch)/dt);
    ctrl_yaw = (kP*err_yaw)+(kD*(err_yaw-preerror_yaw)/dt);
    //ctrl_roll = (ctrl_roll/180.0); // Range adjustment
    //ctrl_pitch = (ctrl_pitch/180.0);
    //ctrl_yaw = (ctrl_yaw/180.0);
    preerror_roll = err_roll;
    preerror_pitch = err_pitch;
    preerror_yaw = err_yaw;
    // Roll = ctrl2 - ctrl4
    // Pitch = ctrl3 - ctrl1
    // Yaw = ctrl1 + ctrl2 + ctrl3 + ctrl4
    //Pi-Roll The-Pitch Psi-Yaw
    ctrl1_value = FLOT(((ctrl_pitch/2.0) + (ctrl_yaw/4.0)) + 0.5);
    ctrl2_value = FLOT(((ctrl_roll/2.0) + (ctrl_yaw/4.0)) + 0.5);
    ctrl3_value = FLOT((-(ctrl_pitch/2.0) + (ctrl_yaw/4.0)) + 0.5);
    ctrl4_value = FLOT((-(ctrl_roll/2.0) + (ctrl_yaw/4.0)) + 0.5);
    if (ctrl1_value<=0.0){ctrl1_value=0.0;}  //To prevent oversignal
    else if (ctrl1_value>=1.0) {ctrl1_value=1.0;}
    if (ctrl2_value<=0.0){ctrl2_value=0.0;}
    else if (ctrl2_value>=1.0) {ctrl2_value=1.0;}
    if (ctrl3_value<=0.0){ctrl3_value=0.0;}
    else if (ctrl3_value>=1.0) {ctrl3_value=1.0;}
    if (ctrl4_value<=0.0){ctrl4_value=0.0;}
    else if (ctrl4_value>=1.0) {ctrl4_value=1.0;}
    Ctrl_1 = ctrl1_value;
    Ctrl_2 = ctrl2_value;
    Ctrl_3 = ctrl3_value;
    Ctrl_4 = ctrl4_value;
}



 
void neutral(){
    ctrl1_value = 0.5;
    ctrl2_value = 0.5;
    ctrl3_value = 0.5;
    ctrl4_value = 0.5;
    Ctrl_1 = ctrl1_value;
    Ctrl_2 = ctrl2_value;
    Ctrl_3 = ctrl3_value;
    Ctrl_4 = ctrl4_value;
}

///////////////////////////////
//   Datalogger       Mbed   //
///////////////////////////////
LocalFileSystem local("local");
int file_no=1;
char filename[256];
FILE *fp;

void Log_file(){
    sprintf(filename, "/local/Data%d.txt", file_no); //save file name for writing
    fp = fopen(filename, "r"); // if file can be loaded, return is 1
    while(fp){
        fclose(fp);
        file_no ++;
        sprintf(filename, "/local/Data%d.txt", file_no);    // Open "tem%d.txt" on the local file system for writing
        fp = fopen(filename, "r");
    }
    fp = fopen(filename, "w");    
}

void Log_data(){
    fprintf(fp, "%.1f,%f,%f,%f,%f,%.0f,%.0f,%.0f,%.1f,%.1f,%.2f,%.2f,%.2f,%.2f\r\n",msec,roll,pitch,yaw,alt,input_roll,input_pitch,input_yaw,kP,kD,ctrl1_value,ctrl2_value,ctrl3_value,ctrl4_value);
}

void send_Blue(){
    if (send_ok == 1){
        send_ok = 0;
        while((LPC_UART1->LSR&0x20)==0); LPC_UART1->THR = '*';
        trans_blue_data(msec,2,1);
        while((LPC_UART1->LSR&0x20)==0); LPC_UART1->THR = ',';
        trans_blue_data(roll,3,2);
        while((LPC_UART1->LSR&0x20)==0); LPC_UART1->THR = ',';
        trans_blue_data(pitch,3,2);
        while((LPC_UART1->LSR&0x20)==0); LPC_UART1->THR = ',';
        trans_blue_data(yaw,3,2);
        while((LPC_UART1->LSR&0x20)==0); LPC_UART1->THR = ',';
        trans_blue_data(alt,2,2);
        while((LPC_UART1->LSR&0x20)==0); LPC_UART1->THR = ',';
        trans_blue_data(velxyz,2,2);
        while((LPC_UART1->LSR&0x20)==0); LPC_UART1->THR = ',';
        trans_blue_data(velz,2,2);
        while((LPC_UART1->LSR&0x20)==0); LPC_UART1->THR = '\n';
    }
}


/////////////////////////////////
//         Main loop           // 
/////////////////////////////////

int main(void)
{   
    AHRS.baud(9600);
    Blue.baud(9600);
    Blue.attach(&Blue_isr);
    AHRS.attach(&AHRS_isr);
    blue_trig.attach(&blue_trig_isr, 0.1);
    neutral();
    Log_file();
    t.start();
        while(1) {
                get_AHRS(&roll,&pitch,&yaw,&velx,&vely,&velz,&velxyz);
                get_Blue(&input_roll,&input_pitch,&input_yaw,&kP,&kD);
                get_Baro(&alt);
                calb_alt();
                alt = alt - alt_zero;
                if (input_roll==0){input_roll = roll;}
                if (input_pitch==0){input_pitch = pitch;}
                if (input_yaw==0){input_yaw = yaw;}
                msec = t.read();
                ctrl_attitude();
                Log_data();
                send_Blue();
                if (input_roll==180.0 && input_pitch==180.0 && input_yaw==180.0){fclose(fp); break;}
    }
}