#include "mbed.h"
#include "PID.h"
#include "Servo.h"
#include "Motor.h"
#include "LSM9DS0.h"
#include "rtos.h"

#define RATE 0.01
#define LSM9DS0_XM_ADDR  0x1D // Would be 0x1E if SDO_XM is LOW
#define LSM9DS0_G_ADDR   0x6B // Would be 0x6A if SDO_G is LOW

//48:1 gear ratio on motors

Serial pc(USBTX, USBRX);
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

LSM9DS0 imu(p9, p10, LSM9DS0_G_ADDR, LSM9DS0_XM_ADDR);
//Kc, Ti, Td, interval
PID controllerR(1.0, 0.0, 0.0, RATE);
PID controllerL(1.0, 0.0, 0.0, RATE);
AnalogIn lpv(p17);
AnalogIn rpv(p18);
AnalogIn rSonar(p19);
AnalogIn lSonar(p20);
AnalogIn ain(p16);
float leftPulse = 0;
float rightPulse = 0;
int l;
int r;
Mutex mlock;
Motor mR(p21, p30, p29); // pwm, fwd, rev
Motor mL(p22, p28, p27);
Servo servo(p23);

void pulseCount(void const* args){
    while(true){
        mlock.lock();
        for(int i; i<10; i++){
            if(rpv.read() != 0){
                r++;
            } 
            if(lpv.read() != 0){
                l++;
            }
        }
        mlock.unlock();
        Thread::wait(10);
    }
} 

void turn(){
    mlock.lock();
    mL.speed(1);
    mR.speed(-1);
    wait(0.3);
    if(rSonar.read()<lSonar.read()){
        mL.speed(1);
        mR.speed(1);
        wait(0.28);
    }else if(rSonar.read()>lSonar.read()){
        mL.speed(-1);
        mR.speed(-1);
        wait(0.28);
    }else{
        mlock.lock();
        mL.speed(1);
        mR.speed(1);
        wait(0.46);
    }
    //wait(0.5);
    mlock.unlock();
    mL.speed(-1);
    mR.speed(1);
}
void irRead(void const* args){
    while(true){
        if(ain > 0.4) {
            myled1 = 1;
            myled2 = 1;
            myled3 = 1;
            myled4 = 1;
            turn();
        }else if(ain<0.4 && ain > 0.3){
            myled1 = 1;
            myled2 = 1;
            myled3 = 1;
            myled4 = 0;
            //turn();
        }else if(ain<0.3 && ain > 0.2){
            myled1 = 1;
            myled2 = 1;
            myled3 = 0;
            myled4 = 0;
        }else if(ain<0.2 && ain > 0.1){
            myled1 = 1;
            myled2 = 0;
            myled3 = 0;
            myled4 = 0;
        }else {
            myled1 = 0;
            myled2 = 0;
            myled3 = 0;
            myled4 = 0;
        }
        Thread::wait(10);
    }
}
    
int main(){
    /* PID Control initialization */
    //imu.begin();
    Thread threadPulse(pulseCount);
    Thread threadIR(irRead);
    //lpv.mode(PullUp);
    //rpv.mode(PullUp);
    controllerR.setInputLimits(0.0, 3000);
    controllerR.setOutputLimits(0.0, 0.9);
    controllerR.setBias(0);
    controllerR.setMode(AUTO_MODE);
    
    controllerL.setInputLimits(0.0, 3000);
    controllerL.setOutputLimits(0.0, 0.9);
    controllerL.setBias(0);
    controllerL.setMode(AUTO_MODE);

    servo.write(0.45);
        
    //Modify setpoints to account for bias (1 foot from left line in hall works well
    controllerR.setSetPoint(2480);
    controllerL.setSetPoint(2460);
    int rOld = 0;
    int lOld = 0;
    while(1){
        mlock.lock();
        rightPulse = (r - rOld)/RATE;
        leftPulse = (l - lOld)/RATE;
        controllerR.setProcessValue(fabs(rightPulse));
        controllerL.setProcessValue(fabs(leftPulse));
        mL.speed(-controllerL.compute());
        mR.speed(controllerR.compute());
        rOld = r;
        lOld = l;
        mlock.unlock();
        Thread::wait(RATE*1000);
    }
}