#include "mbed.h"
#include "rtos.h"
#include "trame.h"
#include "LPC17xx.h"

#define SIGNAL_READ 0x23

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalOut d_out(p9);
DigitalIn d_in(p30);
Thread* debugTH;

Serial pc(USBTX, USBRX);

const int PERIODE = 9600000;

//Variables for MEF
enum states
{
    START           = 0,
    ENTETE          = 1,
    CHARGE_UTILE    = 2,
    CONTROLE        = 3,
    END             = 4
};

int state;
int cntState = 0;
bool nextBit;
bitset<16> buffer;
bitset<640> chargeUtile;
int LENGTH_CHARGE_UTILE_BIT;
int LENGTH_CHARGE_UTILE_BYTE;
char c_chargeUtile[80];
unsigned short CRC_Calculated;
unsigned short CRC_Received;
bool messageReady;

//Variables for send
Thread* frame_sender_Th;
Mail<trame, 8> OutGoingMail;
bool increment_c = false;
bool sending = false;
bool tclock;
bitset<696> *outGoingTrame;
int outGoingLength = 0;
int count = 0;

//Variables for receive
struct inboundChargeMail
{
    char* charge;
    int length;
};
Mail<inboundChargeMail, 8> inboundChargeUtile;
int sync = 0;
bool gbitValueOk = 1;
bool in_val;
int rcv_count = 0;
unsigned long tick_count_read;
bool state_adjust = true;
unsigned long period = 0;
unsigned long tc_periods[8] = {0};
bool rcv_buff[696];

void inputReceiver( void const *args )
{
    int c_count;
    char temp_c;
    string message = "";
    
    while( true )
    {
        temp_c = pc.getc();
        
        if( temp_c == 0xD )
        {
            if( !message.empty() )
            {
               pc.putc( 0xA );
               pc.putc( 0xD );
               std::printf("debug : message sent to mailbox : %s\r\n", message.c_str() );
               OutGoingMail.put( new trame( message ) );
               message = "";
               c_count = 0;
           }
        }
        else if( temp_c == 0x8 )
        {
            pc.putc( temp_c );
            pc.putc( 0x20 );
            pc.putc( temp_c );
            message = message.substr(0, message.length() - 1);
            c_count--;
        }
        else
        {
            if( c_count < 80 )
            {
                pc.putc( temp_c );
                message += temp_c;
                c_count++;
            }
        }
    }
}

bool analyze_state(bool bit)
{
    switch(state)
    {
        case START:
        
            std::printf("START\t");
            
            if(cntState == 0 && bit == 0)
            {
                nextBit = 1;
                cntState++;
            }
            else if (cntState < 6 && bit == nextBit)
            {
                cntState++;
            }
            else if (cntState == 6 && bit == nextBit)
            {
                nextBit = 0;
                cntState++;
            }
            else if (cntState == 7 && bit == nextBit)
            {
                state = ENTETE;
                cntState = 0;
                nextBit = 0;
            }
            else
            {
                state = START;
                return 0;
            }
            
            break;
           
        case ENTETE:
        
            if(cntState < 7 && nextBit == 0)
            {
                std::printf("TEST1: %i \t", cntState);
                cntState++;
                
            }
            else if (cntState == 7 && nextBit == 0)
            {
                std::printf("TEST2: %i \t", cntState);
                nextBit = 1;
            }
            else if (nextBit == 1 && cntState > 0)
            {
                std::printf("TEST3: %i \t", cntState);
                buffer.set(cntState, bit);
                cntState--;
            }
            else if (nextBit == 1 && cntState == 0)
            { 
                buffer.set(cntState, bit);
                state = CHARGE_UTILE;
                LENGTH_CHARGE_UTILE_BIT = (int)(buffer.to_ulong());
                
                cntState = LENGTH_CHARGE_UTILE_BIT - 1;
            }
            else
            {
                state = START;
                return 0;
            }
            
            break;
           
        case CHARGE_UTILE:
            
            std::printf("CHARGE UTILE\t");
            
            if (cntState > 0)
            {
               chargeUtile.set(cntState, bit); 
               cntState--;
            }
            else if (cntState == 0)
            {
                chargeUtile.set(cntState, bit); 
                cntState = 0;
                state = CONTROLE;
                nextBit = 0;
            }
            else
            {
                state = START;
                return 0;
            }
            
            break;
           
        case CONTROLE:
            
            if(nextBit == 0)
            {
                LENGTH_CHARGE_UTILE_BYTE = LENGTH_CHARGE_UTILE_BIT / 8;
                
                for (int i = LENGTH_CHARGE_UTILE_BIT-1; i >= 0; i--)
                {
                    std::printf("%i", (chargeUtile[i] & 0x1));
                    if (i % 8 == 0)
                        c_chargeUtile[ ( ( LENGTH_CHARGE_UTILE_BIT - 1 ) - i ) / 8] = (chargeUtile[i] << 7) | (chargeUtile[i + 1] << 6) | (chargeUtile[i + 2] << 5) | (chargeUtile[i + 3] << 4) | (chargeUtile[i + 4] << 3) | (chargeUtile[i + 5] << 2) | (chargeUtile[i + 6] << 1) | (chargeUtile[i + 7] << 0);
                }
                
                CRC_Calculated = CRC16::calculateCRC16(c_chargeUtile, LENGTH_CHARGE_UTILE_BYTE);
                
                std::printf("CRC Calculated: %hu\t", CRC_Calculated);
                
                nextBit = 1;
                cntState = 14;
                buffer.reset();
                buffer.set(15, bit);
            }
            else if (nextBit == 1 && cntState > 0)
            {
                buffer.set(cntState, bit);
                cntState--;
            }
            else if (nextBit == 1 && cntState == 0)
            {
                buffer.set(cntState, bit);
                CRC_Received = (unsigned short)buffer.to_ulong();
                
                std::printf("CRC Received: %hu\t", CRC_Received);
                
                if (CRC_Received == CRC_Calculated)
                {
                    state = END;
                    nextBit = 0;
                    cntState = 0;
                }
                else
                {
                    state = START;
                    return 0;
                }
            }
            else
            {
                state = START;
                return 0;
            }
            
            break;
           
        case END:
        
            if (nextBit == 0 && nextBit == bit && cntState == 0)
            {
                nextBit = 1;
                cntState++;
            }
            else if (nextBit == 1 && nextBit == bit && cntState < 6)
            {
                cntState++;
            }
            else if (nextBit == 1 && nextBit == bit && cntState == 6)
            {
                nextBit = 0;
                cntState++;
            }
            else if (nextBit == 0 && nextBit == bit && cntState == 7)
            {
                messageReady = true;
                state = START;
            }
            else
            {
                state = START;
                messageReady = false;
                return 0;
            }
        
            break;
    }
    
    return 1;
}

void read()
{
    in_val = d_in.read();
    if( sync < 8 )
    {
        if( in_val || sync > 0 )
        {
            tc_periods[sync] = tick_count_read;
            sync++;
            
            if (sync == 8)
            {
                for (int i = 1; i < sync; i++)
                {
                   period += tc_periods[i]; 
                }
                period = (period/7)/2;
            }
            debugTH->signal_set(0x1);
        }
    }
    else
    {
        debugTH->signal_set(0x1);
        if( tick_count_read > period * 1.5 )
        {
            rcv_buff[ rcv_count ] = !in_val;
            gbitValueOk = analyze_state( !in_val );
            rcv_count++;
        }
        else
        {
            if( state_adjust )
            {
                state_adjust = !state_adjust;
            }
            else
            {
                state_adjust = !state_adjust;
                rcv_buff[ rcv_count ] = !in_val;
                gbitValueOk = analyze_state( !in_val );
                rcv_count++;
            }
        }
        
    }
    if( messageReady )
    {
        inboundChargeMail *mail_t = new inboundChargeMail;
        char ctemp[ 80 ];
        strcpy( ctemp, c_chargeUtile );
        mail_t->charge = ctemp;
        mail_t->length = LENGTH_CHARGE_UTILE_BYTE;
        inboundChargeUtile.put( mail_t );
        
        rcv_count = 0;
        state_adjust = true;
        sync = 0;
        messageReady = false;
        cntState = 0;
    }
    if( !gbitValueOk )
    {
        rcv_count = 0;
        state_adjust = true;
        sync = 0;
        cntState = 0;
    }
    LPC_TIM2->TC = 0;
    LPC_TIM2->IR |= 0xFFFFFFFF;
}

extern "C" void TIMER2_IRQHandler()
{
    tick_count_read = LPC_TIM2->CR0;
    //read();
    LPC_TIM2->TC = 0;
    LPC_TIM2->IR |= 0xFFFFFFFF;
}

extern "C" void TIMER1_IRQHandler( void )
{
    if ((LPC_TIM1->IR & 0x01) == 0x01)
    {
        if( sending )
        {
            tclock = !tclock;
            if( count < outGoingLength )
            {
                d_out = ( ( *outGoingTrame )[ count ] == tclock );
                if(tclock)
                {
                    count++;
                }
                LPC_TIM1->IR |= 1;
            }
            
            if( count == outGoingLength ){
                frame_sender_Th->signal_set(0x3);
                count = 0;
                sending = false;
            }
            debugTH->signal_set(0x1);
        }
        LPC_TIM1->IR |= 1 << 0;
    }
}

void debug( void const *args )
{
    while( true )
    {
        Thread::signal_wait(0x1);
        int tempi1;
        if(tclock)
        {
            tempi1 = d_out;
            std::printf( "%d", tempi1 & 0x1 );
            std::printf( "%d", in_val & 0x1 );
            std::printf( "  %d", count );
            std::printf( "  %d", period );
            std::printf( "  %d\r\n", tick_count_read );
        }
    }
}

void send( trame *trm )
{
    outGoingTrame = trm->getBitset();
    outGoingLength = trm->length;
    std::printf("debug : Sending \r\n");
}

void frame_sender( void const *args )
{
    while( true )
    {
        osEvent evt = OutGoingMail.get();
 
        if( evt.status == osEventMail ) 
        {
            trame *trm = ( trame* )evt.value.p;
 
            std::printf( "frame sender thread\r\n" );
            send( trm );
            sending = true;
            Thread::signal_wait(0x3);
            sending = false;
            count = 0;
            OutGoingMail.free( trm );
            std::printf( "frame sender thread Over \r\n" );
        }
    }
}

void frame_printer( void const *args )
{
    while( true )
    {
        osEvent evt = inboundChargeUtile.get();
        
        if( evt.status == osEventMail )
        {
            inboundChargeMail* mailed_charge = ( inboundChargeMail* )evt.value.p;
            std::printf( "Received frame :\r\n%s", mailed_charge->charge );
            inboundChargeUtile.free( mailed_charge );
        }
    }
}

void init_timer1()
{
    LPC_SC->PCLKSEL0 |= ( 1 << 4 ); //Select Timer 1 = CCLK
    LPC_SC->PCONP |= ( 1 << 2 );    //Power-Up Timer 1
    LPC_TIM1->MR0 = PERIODE;        //Set ticks till interrupt
    LPC_TIM1->MCR = 3;              //Interrupt on MR0 and Reset TC on MR0
    LPC_TIM1->EMR = (3 << 4);
    NVIC_EnableIRQ(TIMER1_IRQn);    //Bind timer 1 to custom funk
    LPC_TIM1->TCR = 1;              //Enable Timer 1
}

void init_timer2()
{
    LPC_PINCON->PINSEL0 |= ( 3 << 8 ); //Select Capture register 2.0
    LPC_SC->PCLKSEL1 |= ( 1 << 12 ); //Select Timer 2 = CCLK
    LPC_SC->PCONP |= ( 1 << 22 ); //Power-Up Timer 2
    LPC_TIM2->TC = 0;
    LPC_TIM2->PC = 0;
    LPC_TIM2->PR = 0;
    LPC_TIM2->TCR |= ( 1 << 1 );
    LPC_TIM2->TCR &= ~( 1 << 1 );
    LPC_TIM2->IR = 0xFFFFFFFF;
    LPC_TIM2->CCR |= 0x00000007;
    NVIC_EnableIRQ(TIMER2_IRQn);
    LPC_TIM2->TCR = 1;
}


int main() 
{
    d_out = 0;
    std::printf("Init Timers...");
    tclock = 1;
    state = START;
    messageReady = false;
    
    init_timer1();
    init_timer2();
    
    std::printf("done\r\n");
    
    std::printf("Init Threads...");
    debugTH = new Thread(debug);
    Thread fp( frame_printer );
    Thread ir( inputReceiver );
    frame_sender_Th = new Thread( frame_sender );
    std::printf("done\r\n");
    
    while( true )
    {
        wait(50000);
    }
}
