#include "trame.h"

trame::trame( string msg )
{
    std::printf("debug : creating trame with %s \n\r", msg);
    length = ( msg.length() * 8 ) + ( 7 * 8 );
    dataLength = ( msg.length() * 8 );
    preambule = 0x55;
    start = 0x7E;
    type_flags = 0x0;
    end = 0x7E;
    message_length = msg.length()*8;
    
    string temp = "";
    for (int i = 0; i < msg.length(); i++)
        {
            temp += bitset<8>( msg.c_str()[ i ]).to_string<char, string::traits_type, string::allocator_type>();
        }
    message = bitset<640>( temp );
    char msg_c[ msg.length() ];
    strcpy( msg_c, msg.c_str() );
    unsigned short crc_t = CRC16::calculateCRC16( msg_c, msg.length() );
    crc16 = crc_t;
}

bitset<696>* trame::getBitset()
{
    bitFrame = new bitset<696>;
    for( int i = 0; i < 8; i++ )
    {
        (*bitFrame)[i] = preambule[7-i];
    }
    
    for( int i = 0; i < 8; i++ )
    {
        (*bitFrame)[i+8] = start[7-i];
    }
    
    for( int i = 0; i < 8; i++ )
    {
        (*bitFrame)[i+16] = type_flags[7-i];
    }
    
    for( int i = 0; i < 8; i++ )
    {
        (*bitFrame)[i+24] = message_length[7-i];
    }
    
    for( int i = 0; i < dataLength; i++ )
    {
        (*bitFrame)[i+32] = message[dataLength-1-i];
    }
    
    for( int i = 0; i < 16; i++ )
    {
        (*bitFrame)[i+32+dataLength] = crc16[15-i];
    }
    
    for( int i = 0; i < 8; i++ )
    {
        (*bitFrame)[i+48+dataLength] = end[7-i];
    }
    
    for( int i = i+56+dataLength; i < 696; i++)
    {
        (*bitFrame)[i] = 0;
    }
    for(int i = 0; i<length; i++)
    {
        std::printf("%d", (*bitFrame)[i] & 0x1);
    }
    return bitFrame;
}
