#include "mbed.h"
#include "EthernetNetIf.h"
#include "MQTTClient.h"
#include "dnsresolve.h"

EthernetNetIf ethernet;    

void callback(char* topic, char* payload); /*Callback function prototype*/

MQTTClient mqtt;

Serial pc(USBTX, USBRX); // tx, rx

void callback(char* topic, char* payload)
{
    printf("Topic: %s\r\n", topic);
    printf("Payload: %s\r\n\r\n", payload);
    //Send incoming payloads back to topic "/mbed".
//    mqtt.publish("mbed", payload);
}

int main() 
{  
   pc.baud(115200);
    printf("\r\n############### MQTTClient Tester  ###########\r\n\r\n");
    DNSResolver resolver;
    
    EthernetErr ethErr = ethernet.setup();
    if(ethErr){
        printf("Ethernet Error %d\r\n", ethErr);  
        return -1;
    } 
    
    char clientID[] = "mbed";   /*Client name show for MQTT server*/
    char sub_topic[] = "/v2/feeds/XXXXXX.csv";   /*Subscribe to topic - a Pachube feed, replace XXXXXX with your own feed number */
    
    IpAddr serverIpAddr = resolver.resolveName("api.pachube.com");
    
    mqtt.init(&serverIpAddr, 1883, "your-api-key-here", NULL, callback);
    
    if(!mqtt.connect(clientID)){
        printf("\r\nConnect to server failed ..\r\n");
        return -1;
    }
    printf("\r\nConnect to server sucessed ..\r\n");
    
//    mqtt.publish(pub_topic, "Hello here is mbed...");
    mqtt.subscribe(sub_topic);
    
    int flag = 0;
    /*Keep alive for 300s or 5mins*/
    while(flag < 300){
        Net::poll();
        wait(1);
        flag++;
        mqtt.live();
    }
    
    mqtt.disconnect();
    
    printf("#### End of the test.. ####\r\n\r\n");
}
