/** IoT Gateway RFM12B payload Simple format handling
 *
 * @author Andrew Lindsay
 *
 * @section LICENSE
 *
 * Copyright (c) 2012 Andrew Lindsay (andrew [at] thiseldo [dot] co [dot] uk)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 * @section DESCRIPTION
 * 
 * 
 */

#ifndef _PAYLOADSIMPLE_H
#define _PAYLOADSIMPLE_H

#include "mbed.h"
#include "PayloadDef.h"


typedef struct {
    int16_t reading;        // Reading
}  __attribute__((packed)) PayloadSimpleReading;


/** Simple payload format class
 * Format is 2 bytes per reading with low byte first.
 *
 */
class PayloadSimple: public PayloadDef {
public:
    /** Default Constructor
     */
    PayloadSimple();
    
    /** Alternative constructor for passing payload
     *
     * @param pptr  Pointer to payload data
     * @param plen  Length of paylod data
     */
    PayloadSimple( uint8_t *pptr, short plen );

    /** Get the number of readings in a payload
     *
     * @returns the number of readings found in payload so they can be read
     */
    virtual short numReadings();

    /** Get a single reading from the payload
     *
     * @param readingNum The number of the reading, starts from 0 upto number of readings in payload
     * @returns Integer representation of reading
     */
    virtual int reading( short readingNum );

    /** Get the sensor ID for the specified reading within the payload
     *
     * @param readingNum The number of the reading, starts from 0 upto number of readings in payload
     * @returns Integer representation of reading
     */
    virtual short sensorId( short readingNum );
};

#endif /* _PAYLOADSIMPLE_H */