/** IoT Gateway Output definition for Open Energy Monitor emonCms 
 *
 * @author Andrew Lindsay
 *
 * @section LICENSE
 *
 * Copyright (c) 2012 Andrew Lindsay (andrew [at] thiseldo [dot] co [dot] uk)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 * @section DESCRIPTION
 * 
 * API URL: http://host/emoncms/api/post?apikey=key&json={power:252.4}
 ,temperature:15.4}
 * 
 */

#include "mbed.h"
#include "OutputEmonCms.h"

DigitalOut emonActivityLED(p29, "activityLED");

// Constructor
OutputEmonCms::OutputEmonCms() {
    sendCount = 0;
}

/** Alternative Constructor
  */
OutputEmonCms::OutputEmonCms( char *internalBufferStart, char *url, char *key ) {
    sendCount = 0;
    dataBuffer = internalBufferStart;
    apiUrl = url;
    apiKey = key;
    // Setup start of URL buffer
    init();
}


void OutputEmonCms::init( ) {
    dbufPtr = dataBuffer;
    sprintf(dataBuffer, apiUrl, apiKey );
    dbufPtr = dataBuffer + strlen(dataBuffer);
    *dbufPtr = '\0';
    hasData = false;
}

// Datafeed us the name of the value
void OutputEmonCms::addReading(char *dataFeed, char *dataStream, char *reading ) {

    snprintf(dbufPtr, DATABUF_SIZE, "{%s:%s}\0", dataFeed, reading);
    hasData = true;
    send();
}


int OutputEmonCms::send( void ) {
//    char urlBuf[64];
    HTTPClient http;

    if ( hasData && strlen( dataBuffer ) > 1 ) {

        HTTPText csvContent("application/json");
        csvContent.set(std::string(dataBuffer));

        // uri for post includes feed ID and datastream ID
//        printf("URL: %s\n",dataBuffer);


        emonActivityLED = 1;
        sendCount++;
        // result should be 0 and response should be 200 for successful post
//        printf("EmonCms send count %d\n", sendCount);
/*
        printf("\nHEAP STATS\n");
        __heapstats((__heapprt)fprintf,stderr);
        printf("\nHEAP CHECK\n");
        __heapvalid((__heapprt)fprintf,stderr, 0);
        printf("\nStackP: %ld\n",__current_sp());
        printf("---------------\n");
*/
        HTTPResult result = http.get(dataBuffer, NULL);
        int response = http.getHTTPResponseCode();
        printf("updateDataStream(%d)\n", response );
        emonActivityLED = 0;
    }

    init();
    return 0;
}

int OutputEmonCms::getSendCount( void ) {
    return sendCount;
}
    