/** IoT Gateway RFM12B payload V2 format handling
 *
 * @author Andrew Lindsay
 *
 * @section LICENSE
 *
 * Copyright (c) 2012 Andrew Lindsay (andrew [at] thiseldo [dot] co [dot] uk)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 * @section DESCRIPTION
 * 
 * 
 */

#include "mbed.h"
#include "PayloadV2.h"


// Constructors for a new 21 payload
PayloadV2::PayloadV2( ) : PayloadDef() {}

PayloadV2::PayloadV2( uint8_t *pptr, short plen ): PayloadDef( pptr, plen ) {
    uint8_t *ptr = pptr;
    ptr += 4;
    // Scan through payload counting readings
    while ( ptr < (pptr + plen) ) {
        switch ( *ptr & 0xf0 ) {
            case 0x00:      // Byte
                readingCount++;
                ptr += 4;
                break;
            case 0x10:      // short, 16 bit
                readingCount++;
                ptr += 5;
                break;
            case 0x20:      // 32 bit
                readingCount++;
                ptr += 7;
                break;
            case 0x30:      // string
                readingCount++;
                ptr += 2;
//                printf("String %d\n", *ptr);
                if ( *ptr <= 40 )
                    ptr += *ptr;
                break;
        }
    }
}

short PayloadV2::numReadings() {
    return readingCount;
}

uint8_t *PayloadV2::readingPtr( short readingNum ) {
    uint8_t *ptr = payloadBuffer;
    short currentReading = 0;
    
//    for(int i=0; i<payloadLen; i++ ) 
//        printf("%02X ",*ptr++);
//    ptr = payloadBuffer;
//    printf("\n");
    ptr += 4;

    // Scan through payload readings
    while ( ptr < (payloadBuffer + payloadLen) ) {
        switch ( *ptr & 0xf0 ) {
            case 0x00:      //
                if ( currentReading == readingNum )
                    return ptr;
                currentReading++;
                ptr += 3;
                break;
            case 0x10:      //
                if ( currentReading == readingNum )
                    return ptr;
                currentReading++;
                ptr += 4;
                break;
            case 0x20:      //
                if ( currentReading == readingNum )
                    return ptr;
                currentReading++;
                ptr += 6;
                break;
            case 0x30:      //
                if ( currentReading == readingNum )
                    return ptr;
                currentReading++;
                ptr += 2;
                if ( *ptr <= 40 )
                    ptr += *ptr;
                break;
            default:
                ptr++;
        }
    }
    return NULL;
}

int8_t PayloadV2::readingByte( short readingNum ) {
    uint8_t *ptr = readingPtr( readingNum );

    payloadv2ByteReading *bptr = (payloadv2ByteReading*)ptr;
    return bptr->reading;
}

short PayloadV2::readingShort( short readingNum ) {
    uint8_t *ptr = readingPtr( readingNum );
    payloadv2ShortReading *bptr = (payloadv2ShortReading*)ptr;
    return bptr->reading;
}

int PayloadV2::reading( short readingNum ) {
    return( readingLong( readingNum ) );
}
    
int PayloadV2::readingLong( short readingNum ) {
    uint8_t *ptr = readingPtr( readingNum );

    payloadv2LongReading *bptr = (payloadv2LongReading*)ptr;
//    printf("Long Reading %ld\n",bptr->reading);
    return bptr->reading;
}

short PayloadV2::readingType( short readingNum ) {
    uint8_t *ptr = readingPtr( readingNum );
    payloadv2Header *bptr = (payloadv2Header*)ptr;
    return bptr->typeId >>4;
}

short PayloadV2::sensorId( short readingNum ) {
    uint8_t *ptr = readingPtr( readingNum );

    payloadv2Header *bptr = (payloadv2Header*)ptr;
    
//    printf("Sensor ID from pkt is %d, values %2x %2x\n", (bptr->typeId & 0x0f << 8) | bptr->id,bptr->typeId, bptr->id );
    return (bptr->typeId & 0x0f << 8) | bptr->id;
}
