/** IoT Gateway Output definition for Pachube
 *
 * @author Andrew Lindsay
 *
 * @section LICENSE
 *
 * Copyright (c) 2012 Andrew Lindsay (andrew [at] thiseldo [dot] co [dot] uk)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 * @section DESCRIPTION
 * 
 * 
 */

#include "mbed.h"
#include "OutputPachube.h"

DigitalOut activityLED(p29, "activityLED");

// Constructor
OutputPachube::OutputPachube() {
    sendCount = 0;
}

/** Alternative Constructor
  */
OutputPachube::OutputPachube( char *internalBufferStart, char *url, char *key ) {
    sendCount = 0;
    dataBuffer = internalBufferStart;
    apiUrl = url;
    apiKey = key;
    dbufPtr = dataBuffer;
    *dbufPtr = '\0';
}
    

void OutputPachube::init( ) {
    dbufPtr = dataBuffer;
    *dbufPtr = '\0';
}

void OutputPachube::addReading(char *dataFeed, char *dataStream, char *reading ) {
    char tmpBuf[20];
    int thisFeed = atoi( dataFeed );

    if ( thisFeed != currentFeed )
        send();

    currentFeed = thisFeed;
    snprintf(tmpBuf, DATABUF_SIZE, "%s,%s\n", dataStream, reading);
    strcat( dataBuffer, tmpBuf );
}


int OutputPachube::send( void ) {
    char urlBuf[API_URL_LENGTH];
    HTTPClient http;

    if ( strlen( dataBuffer ) > 1 ) {
        http.setRequestHeader("X-PachubeApiKey", apiKey);

        HTTPText csvContent("text/csv");
        // Get the string for Pachube
        csvContent.set(std::string(dataBuffer));

        // uri for post includes feed ID and datastream ID
        snprintf(urlBuf, API_URL_LENGTH, apiUrl, currentFeed );
//        printf("URL: %s\n",urlBuf);


        activityLED = 1;
        // result should be 0 and response should be 200 for successful post
        sendCount++;
//        printf("Pachube Send count %d\n", sendCount);

/*        printf("\nHEAP STATS\n");
        __heapstats((__heapprt)fprintf,stderr);
        printf("\nHEAP CHECK\n");
        __heapvalid((__heapprt)fprintf,stderr, 0);
        printf("\nStackP: %ld\n",__current_sp());
        printf("---------------\n");
*/
        HTTPResult result = http.post(urlBuf, csvContent, NULL);
        int response = http.getHTTPResponseCode();
//        printf("updateDataStream(%d)\n", response );
        activityLED = 0;
    }

    dbufPtr = dataBuffer;
    *dbufPtr = '\0';
    
    return 0;
}


int OutputPachube::getSendCount( void ) {
    return sendCount;
}
