/** IoT Gateway Output definition for MQTT
 *
 * @author Andrew Lindsay
 *
 * @section LICENSE
 *
 * Copyright (c) 2012 Andrew Lindsay (andrew [at] thiseldo [dot] co [dot] uk)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 * @section DESCRIPTION
 * 
 * 
 */

#ifndef _OUTPUTMQTT_H
#define _OUTPUTMQTT_H

#include "iotgateway.h"
#include "mbed.h"
#include "MQTTClient.h"

/** Implementation of MQTT output class
 *
 */
class OutputMqtt {
public:
    /** Default Constructor
     */
    OutputMqtt();

    /** Initialise output definition object
     */
    virtual bool init();
    
    /** Set the IP address of the host
     * 
     * @param serverIpAddr IP Addres of host
     * @param port         Port to use
     * @param username     Username or NULL if not used
     * @param password     Password or NULL if not used
     */
    void initConnection(IpAddr *serverIpAddr, short port, char *username, char *password );

    /** Add a character pointer reading to output 
     * 
     * @param topic The topic to publish to
     * @param unused Unused in this output
     * @param reading The new value
     */
    virtual void addReading(char *topic, char *unused, char *reading );

    /** Send any collected readings
     * Does nothing in MQTT as already published 
     * 
     * @returns -1 for fail, 1 for success
     */
    virtual int send();
    
    /** Get the send count
     * 
     * @returns mumber of API calls made
     */
    virtual int getSendCount( );


protected:
    MQTTClient mqtt;
    int sendCount;
    IpAddr *serverIpAddr;
    short port;
    char *username;
    char *password;

};

#endif /* _OUTPUTMQTT_H */