/** IoT Gateway Output definition for Sen.Se
 *
 * @author Andrew Lindsay
 *
 * @section LICENSE
 *
 * Copyright (c) 2012 Andrew Lindsay (andrew [at] thiseldo [dot] co [dot] uk)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 * @section DESCRIPTION
 * 
 * 
 */
 
#ifndef _OUTPUTSENSE_H
#define _OUTPUTSENSE_H

#include "iotgateway.h"
#include "mbed.h"
#include "HTTPClient.h"
#include "HTTPText.h"

/** Output definition class for sending readings to Pachube
 */
class OutputSenSe {
public:
    /** Default Constructor
     */
    OutputSenSe();

    /** Alternative Constructor
     *
     * @param internalBufferStart An internal buffer used to build up requests. 
     * @param url  Pointer to API Url
     * @param key  Pointer to API key
     */
    OutputSenSe( char *internalBufferStart, char *url, char *key );

    /** Initialise output definition object
     */
    virtual void init();
    
    /** Add a character pointer reading to output 
     * 
     * @param dataFeed The feed to update
     * @param dataStream The data stream within the feed to update or null if no feed
     * @param reading The new value
     */
    virtual void addReading(char *dataFeed, char *dataStream, char *reading );
    
    /** Send any collected readings to the api
     * 
     * @returns -1 for fail, 1 for success
     */
    virtual int send();

    /** Get the send count
     * 
     * @returns mumber of API calls made
     */
    virtual int getSendCount( );

protected:
    int sendCount;
    // Sen.Se config
    char *apiUrl;
    char *apiKey;
    char *dataBuffer;       // Pointer to start of databuffer
    char *dbufPtr;
    int currentFeed;
};

#endif /* _OUTPUTSENSE_H */