/** IoT Gateway Output definition for Sen.Se
 *
 * @author Andrew Lindsay
 *
 * @section LICENSE
 *
 * Copyright (c) 2012 Andrew Lindsay (andrew [at] thiseldo [dot] co [dot] uk)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 * @section DESCRIPTION
 * 
 * 
 */

#include "mbed.h"
#include "OutputSenSe.h"

DigitalOut senseActivityLED(p29, "activityLED");

// Constructor
OutputSenSe::OutputSenSe() {
    sendCount = 0;
}

/** Alternative Constructor
  */
OutputSenSe::OutputSenSe( char *internalBufferStart, char *url, char *key ) {
    sendCount = 0;
    dataBuffer = internalBufferStart;
    apiUrl = url;
    apiKey = key;
    init();
}


void OutputSenSe::init( ) {
    dbufPtr = dataBuffer;
    *dbufPtr = '\0';
}

/*
  {
    "feed_id": <another_feed_id>,
    "value": <another_event_value>
  }
*/

void OutputSenSe::addReading(char *dataFeed, char *dataStream, char *reading ) {

    snprintf(dataBuffer, DATABUF_SIZE, "{ \"feed_id\" : %s, \"value\" : \"%s\" }\n", dataFeed, reading);
//    printf("%s\n",dataBuffer);
    send();
}


int OutputSenSe::send( void ) {
    char urlBuf[API_URL_LENGTH];
    HTTPClient http;

    if ( strlen( dataBuffer ) > 1 ) {

        HTTPText csvContent("application/json");
        // Get the string for Pachube
        csvContent.set(std::string(dataBuffer));

        // uri for post includes feed ID and datastream ID
        snprintf(urlBuf, API_URL_LENGTH, apiUrl, apiKey );
//        printf("URL: %s\n",urlBuf);


        senseActivityLED = 1;
        sendCount++;
        // result should be 0 and response should be 200 for successful post
//        printf("Sen.Se Send count %d\n", sendCount);

/*        printf("\nHEAP STATS\n");
        __heapstats((__heapprt)fprintf,stderr);
        printf("\nHEAP CHECK\n");
        __heapvalid((__heapprt)fprintf,stderr, 0);
        printf("\nStackP: %ld\n",__current_sp());
        printf("---------------\n");
*/
        HTTPResult result = http.post(urlBuf, csvContent, NULL);
        int response = http.getHTTPResponseCode();
//        printf("updateDataStream(%d)\n", response );
        senseActivityLED = 0;
    }

    dbufPtr = dataBuffer;
    *dbufPtr = '\0';
    
    return 0;
}


int OutputSenSe::getSendCount( void ) {
    return sendCount;
}
