/** IoT Gateway Output definition for MQTT
 *
 * @author Andrew Lindsay
 *
 * @section LICENSE
 *
 * Copyright (c) 2012 Andrew Lindsay (andrew [at] thiseldo [dot] co [dot] uk)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 * @section DESCRIPTION
 * 
 * 
 */
 
#include "mbed.h"
#include "OutputMqtt.h"

// Constructor
OutputMqtt::OutputMqtt() {
    sendCount = 0;
}

static void callback(char* topic, char* payload); /*Callback function prototype*/
//MQTTClient mqtt(serverIpAddr, 1883, callback);


static void callback(char* topic, char* payload)
{
    printf("Topic: %s\r\n", topic);
    printf("Payload: %s\r\n\r\n", payload);
}

void OutputMqtt::initConnection( IpAddr *serverIpAddr, short port, char *username, char *password ) {
    this->serverIpAddr = serverIpAddr;
    this->port = port;
    this->username = username;
    this->password = password;
}

bool OutputMqtt::init( ) {
//    printf("MQTT server ip is %d.%d.%d.%d\n",serverIpAddr[0],serverIpAddr[1],serverIpAddr[2],serverIpAddr[3]);
    mqtt.init(serverIpAddr, port, username, password, callback);
    if(!mqtt.connect("IoTGateway")){
        printf("\r\nConnect to server failed ..\r\n");
        mqtt.disconnect();
        return false;
    }
    return true;
}

// These are used to send
void OutputMqtt::addReading(char *topic, char *unused, char *reading ) {
    sendCount++;
    mqtt.publish( topic, reading );
}


// send here does nothing
int OutputMqtt::send( void ) {
    mqtt.live();
    return 0;
}


int OutputMqtt::getSendCount( void ) {
    return sendCount;
}
