/** IoT Gateway RFM12B payload V1 format handling
 *
 * @author Andrew Lindsay
 *
 * @section LICENSE
 *
 * Copyright (c) 2012 Andrew Lindsay (andrew [at] thiseldo [dot] co [dot] uk)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 * @section DESCRIPTION
 * 
 * 
 */

#include "mbed.h"
#include "RF12B.h"
#include "PayloadV1.h"


// Constructors for a new V1 payload
PayloadV1::PayloadV1( ) : PayloadDef() {}
PayloadV1::PayloadV1( uint8_t *pptr, short plen ): PayloadDef( pptr, plen ) {
    readingCount = (short) (payloadBuffer[2] - 1) / 3;
}

short PayloadV1::numReadings() {
    return readingCount;
}

int PayloadV1::reading( short readingNum ) {
short reading = (payloadBuffer[6 + (readingNum * 3)] << 8) + payloadBuffer[5 + (readingNum * 3)];
    return (int)(reading);
}

short PayloadV1::sensorId( short readingNum ) {
    return (short)(payloadBuffer[4 + (readingNum * 3)]);
}
