/** IoT Gateway RFM12B payload definition
 *
 * @author Andrew Lindsay
 *
 * @section LICENSE
 *
 * Copyright (c) 2012 Andrew Lindsay (andrew [at] thiseldo [dot] co [dot] uk)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 * @section DESCRIPTION
 * 
 * 
 */

#ifndef _PAYLOADDEF_H
#define _PAYLOADDEF_H

#include "mbed.h"

#define MAX_PAYLOAD_SIZE 76

/** Payload definition base class
 */
class PayloadDef {
public:
    /** Default Constructor 
    */
    PayloadDef();
    
    /** Alternative constructor for passing payload
     *
     * @param pptr  Pointer to payload data
     * @param plen  Length of paylod data
     */
    PayloadDef( uint8_t *pptr, short plen );

    /** Get the number of readings in a payload
     *
     * @returns the number of readings found in payload so they can be read
     */
    virtual short numReadings() = 0;
    
    /** Get a single reading from the payload
     * Other payload definition classes may provide alternative versions for bytes, words or strings
     *
     * @param readingNum The number of the reading, starts from 0 upto number of readings in payload
     * @returns Integer representation of reading
     */
    virtual int reading( short readingNum ) = 0;
    
    /** Get the sensor ID for the specified reading within the payload
     * Other payload definition classes may provide alternative versions for bytes, words or strings
     *
     * @param readingNum The number of the reading, starts from 0 upto number of readings in payload
     * @returns Integer representation of reading
     */
    virtual short sensorId( short readingNum ) = 0;

    /** Get the node ID from the data header
     * 
     * @returns Single byte Node ID from the received header data
     */
    uint8_t nodeId();

    /** Get the group ID from the data header
     * 
     * @returns Single byte Group ID from the received header data
     */
    uint8_t groupId();

protected:
    short readingCount;
    short payloadLen;
    uint8_t payloadBuffer[MAX_PAYLOAD_SIZE];

};

#endif /* _PAYLOADDEF_H */