/* Copyright (c) 2012 Andrew Lindsa, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * Simple scrolling message display for mbed and HT1632C based LED matrix displays
 */
#include "mbed.h"
#include "rtos.h"
#include "HT1632_LedMatrix.h"

Serial pc(USBTX, USBRX); // tx, rx

// Define the onboard LEDs to use as status indicators
DigitalOut led1(LED1);      // Activity
DigitalOut led2(LED2);      // Activity, alternates with led2

// create object to control the LED Matrix
HT1632_LedMatrix led = HT1632_LedMatrix();

#define DISPDELAY 90

// Define the message, add blanks to front so it doesnt lose first part immediately
char* msg = "    The quick brown fox jumped over the lazy dog!!!";
int crtPos = 0;
int msgx = 1;    // position on message screen of current character, set to 1 to allow for first scroll

/*
* This works for multiple 8x32 matrix.
*/
void displayScrollingLine( void const* )
{
    int y,xmax,ymax;
    led.getXYMax(&xmax,&ymax);
    while(true) {
        // shift the whole screen 6 times, one column at a time;
        for (int x=0; x < 6; x++) {
            led.scrollLeft(1,0);
            msgx--;
            // fit as much as we can on display
            while (!led.putChar(msgx,0,msg[crtPos])) { // zero return if it all fitted on display
                led.getXY(&msgx,&y);
                crtPos++; // we got all of the character on!!
                if (crtPos >= strlen(msg)) {
                    crtPos = 0;
                }
            }
            led.putShadowRam();
            Thread::wait(DISPDELAY);
        }
    }
}


int main()
{
    // Define how many displays we have, older 0832 allowed vertical stacking
    // newer ones dont unless you want a gap between the displays.
    // Num horizontal displays 1 to 4, num vertical displays 1 to 4. Max 4 displays can be used.
    // Usable combinations are 1,1; 2,1; 3,1; 4,1; and 2,2; 1,2; 1,3; 1,4; with gaps!!
    led.init(2,1);
    pc.baud(9600);
    printf("LED Matrix dislay test");
    led.clear();
    led.setBrightness(8);

    Thread displayTask(displayScrollingLine, NULL, osPriorityNormal, 1024 * 4);

    // Show we are still working by alternatively flashing LED1 and LED2, once a second
    led1 = 0;       // Working
    led2 = 1;       // Alternate with led1
    while(1) {
        led1=!led1;
        led2=!led2;
        Thread::wait(1000);
    }
}
