/* mbed EM-406 GPS Module Library
 * Copyright (c) 2008-2010, sford
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#include "GPS.h"

GPS::GPS(PinName tx, PinName rx, int baudrate) : _gps(tx, rx) {
    _gps.baud(baudrate);    
    longitude = 0.0;
    latitude = 0.0;
    altitude = 0.0;
}

int GPS::sample() {
    //float time;
    char ns, ew;
    int lock;
    int satsInUse;
    float hdop;

    while(1) {        
        getline();

        // Check if it is a GPGGA msg (matches both locked and non-locked msg)
        // GPGGA,212700.000,5124.4324,N,00115.7464,W,1,8,1.30,113.7,M,47.5,M,,*47
        // Position -1.929107, 51.407211
        //          51.4136298,-1.2670097
        //Position -1.262323, 51.407383
        if(sscanf(msg, "GPGGA,%f,%f,%c,%f,%c,%d,%d,%f,%f", &time, &latitude, &ns, &longitude, &ew, &lock, &satsInUse, &hdop, &altitude) >= 1) { 
            if(!lock) {
                longitude = 0.0;
                latitude = 0.0;
                altitude = 0;
                return 0;
            } else {
                //printf("%s\n\r",msg);
                if(ns == 'S') {    latitude  *= -1.0; }
                if(ew == 'W') {    longitude *= -1.0; }
                float degrees = trunc(latitude / 100.0f);
                float minutes = latitude - (degrees * 100.0f);
                //printf("LAT degrees %f, minutes %f\n\r",degrees,minutes);
                latitude = degrees + (minutes / 60.0f);    
                
                degrees = trunc(longitude / 100.0f);    // * 0.01f);
                minutes = longitude - (degrees * 100.0f);
                //printf("LON degrees %f, minutes %f\n\r",degrees,minutes);
                longitude = degrees + (minutes / 60.0f);
                return 1;
            }
        }
    }
}

float GPS::trunc(float v) {
    if(v < 0.0f) {
        v*= -1.0f;
        v = floor(v);
        v*=-1.0f;
    } else {
        v = floor(v);
    }
    return v;
}

void GPS::getline() {
    while(_gps.getc() != '$');    // wait for the start of a line
    for(int i=0; i<255; i++) {
        msg[i] = _gps.getc();
//        printf("%c",msg[i]);
        if(msg[i] == '\r') {
            msg[i] = 0;
            return;
        }
    }
//    error("Overflowed message limit");
//    printf("Overflow");
}
