// Demo Ciseco LLAPSerial usage

/**
 * The MIT License (MIT)
 * 
 * Copyright (c) 2014 Andrew Lindsay
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#include "mbed.h"
#include "LLAPSerial.h"

//LLAPSerial srf(PA_11, PA_12, PA_9);
// or
//LLAPSerial srf(PA_11, PA_12, PA_9, false,"MB");
LLAPSerial srf(PA_2, PA_3, PA_9, false,"MB");

//Serial pc(USBTX, USBRX);
Serial pc(PA_11, PA_12);

int main()
{
    pc.baud(115200);
    pc.printf("LLAP Test\n");

    srf.sendMessage("STARTED");
    wait_ms(100);
    srf.sendMessage("TMPA", "123");
    wait_ms(100);
    srf.sendInt("TMPA", 123);
    wait_ms(100);
    srf.sendIntWithDP("TMPA", 1230,2);
    while( 1 ) {
        if( srf.bMsgReceived ) {
            //myled = !myled;
            pc.printf("Received: %s\n\r",srf.sMessage );
            srf.bMsgReceived = false;   // Clear flag to indicate msg handled
        }
    }

}
