#include "mbed.h"


// Not all LED pixels are RGB order; 36mm type expects GRB data.
// Optional flag to constructors indicates data order (default if
// unspecified is RGB).  As long as setPixelColor/getPixelColor are
// used, other code can always treat 'packed' colors as RGB; the
// library will handle any required translation internally.
#define WS2801_RGB 0
#define WS2801_GRB 1

#define ws_swap(a, b) { int16_t t = a; a = b; b = t; }

class Adafruit_WS2801
{

public:

    // Configurable pins:
    Adafruit_WS2801(int16_t n, PinName dpin, PinName cpin, uint8_t order=WS2801_RGB);
    Adafruit_WS2801(int16_t x, int16_t y, PinName dpin, PinName cpin, uint8_t order=WS2801_RGB);
    // Use SPI hardware; specific pins only:
    Adafruit_WS2801(uint16_t n, uint8_t order=WS2801_RGB);
// Adafruit_WS2801(uint16_t x, uint16_t y, uint8_t order=WS2801_RGB);
    // Empty constructor; init pins/strand length/data order later:
//  Adafruit_WS2801();
    // Release memory (as needed):
    ~Adafruit_WS2801();

    void begin(void);
    void show(void);
    void setPixelColor(uint16_t n, uint8_t r, uint8_t g, uint8_t b);
    void setPixelColor(uint16_t n, uint32_t c);
    void setPixelColor(int16_t x, int16_t y, uint8_t r, uint8_t g, uint8_t b);
    void setPixelColor(int16_t x, int16_t y, uint32_t c);
    void updatePins(PinName dpin, PinName cpin); // Change pins, configurable
    void updatePins(void); // Change pins, hardware SPI
    void updateLength(uint16_t n); // Change strand length
    void updateOrder(uint8_t order); // Change data order

    // Basic drawing functions, line and circle. These are only useful when pixels arranged in a matrix
    void drawLine(int16_t x0, int16_t y0, int16_t x1, int16_t y1, uint32_t color);
    void drawFastVLine(int16_t x, int16_t y, int16_t h, uint32_t color);
    void drawFastHLine(int16_t x, int16_t y, int16_t w, uint32_t color);
    void drawRect(int16_t x, int16_t y, int16_t w, int16_t h, uint32_t color);
    void drawCircle(int16_t x0, int16_t y0, int16_t r, uint32_t color);
//    void fillCircle(int16_t x0, int16_t y0, int16_t r, uint32_t color);
//    void fillCircleHelper(int16_t x0, int16_t y0, int16_t r, uint8_t cornername, int16_t delta, uint32_t color);

    uint16_t numPixels(void);
    uint32_t getPixelColor(uint16_t n);

private:

    uint16_t
    numLEDs,
    width,     // used with matrix mode
    height;    // used with matrix mode
    uint8_t
    *pixels,   // Holds color values for each LED (3 bytes each)
    rgb_order // Color order; RGB vs GRB (or others, if needed in future)
    ;
    DigitalOut  clkpin;
    DigitalOut  datapin;     // Clock & data pin numbers
    void    alloc(uint16_t n);
//    startSPI(void);
    bool hardwareSPI; // If 'true', using hardware SPI
    bool  begun;       // If 'true', begin() method was previously invoked
};
