#include "mbed.h"
#include "cc3000.h"

#include "TCPSocketConnection.h"
#include "TCPSocketServer.h"

#include "HTTPClient.h"
#include "Websocket.h"

extern cc3000 wifi;
extern Serial pc;
HTTPClient http;

const char WEB_SOCKET_URL[] = {"ws://sockets.mbed.org/ws/SolderSplashLabs/wo"};
const char* ECHO_SERVER_ADDRESS = "192.168.0.10";
const int ECHO_SERVER_PORT_TCP = 80;
char hello[] = "Hello World\r\n";
char str[512];

// ------------------------------------------------------------------------------------------------------------
/*!
    @brief Exercise the HTTP Client library
*/
// ------------------------------------------------------------------------------------------------------------
void HttpClientTest ( void )
{
    //GET data
    printf("\r\nTrying to fetch page... \r\n");
    int ret = http.get("http://mbed.org/media/uploads/donatien/hello.txt", str, 128);
    if (!ret)
    {
      printf("Page fetched successfully - read %d characters \r\n", strlen(str));
      printf("Result: %s \r\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d \r\n", ret, http.getHTTPResponseCode());
    }
 
    //POST data
    HTTPMap map;
    HTTPText inText(str, 512);
    map.put("Hello", "World");
    map.put("test", "1234");
    printf(" \r\nTrying to post data... \r\n");
    ret = http.post("http://httpbin.org/post", map, &inText);
    if (!ret)
    {
      printf("Executed POST successfully - read %d characters \r\n", strlen(str));
      printf("Result: %s \r\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d \r\n", ret, http.getHTTPResponseCode());
    }
 
    //PUT data
    strcpy(str, "This is a PUT test!");
    HTTPText outText(str);
    //HTTPText inText(str, 512);
    printf(" \r\nTrying to put resource... \r\n");
    ret = http.put("http://httpbin.org/put", outText, &inText);
    if (!ret)
    {
      printf("Executed PUT successfully - read %d characters \r\n", strlen(str));
      printf("Result: %s \r\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d \r\n", ret, http.getHTTPResponseCode());
    }
 
    //DELETE data
    //HTTPText inText(str, 512);
    printf(" \r\nTrying to delete resource... \r\n");
    ret = http.del("http://httpbin.org/delete", &inText);
    if (!ret)
    {
      printf("Executed DELETE successfully - read %d characters \r\n", strlen(str));
      printf("Result: %s \r\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d \r\n", ret, http.getHTTPResponseCode());
    }
 
}

// ------------------------------------------------------------------------------------------------------------
/*!
    @brief Open a WebSocket, send a string
*/
// ------------------------------------------------------------------------------------------------------------
void WebSocketTest ( void )
{
int res = 0;
uint16_t counter = 0;
uint16_t reconnects = 0;
uint8_t myMAC[8];
char websocketstr[100];

    wifi.get_mac_address(myMAC);
    
    Websocket ws((char *)WEB_SOCKET_URL);
    if ( ws.connect() )
    {
        printf("Connected to websocket server.\r\n");
        
        printf("\r\n!! Press any key to stop sending !!\r\n\r\n");
        while (1)
        {   
            counter ++;
            sprintf(websocketstr, "WiFi DipCortex / CC3000 - %05d - %02x:%02x:%02x:%02x:%02x:%02x\r\n", counter, myMAC[0], myMAC[1], myMAC[2], myMAC[3], myMAC[4], myMAC[5]);
            
            if ( wifi.is_connected() )
            {
                res = ws.send(websocketstr);
                printf("Reconnects : %05d, Messages Sent : %05d, Websocket send returned : %d.\r\n", reconnects, counter, res);
            
                if ( -1 == res ) 
                {
                    printf("Websocket Failure, reconnecting .... \r\n");
                    ws.close();
                    if ( ws.connect() )
                    {
                        // Reconnected
                        reconnects ++;
                    }
                    else
                    {
                        // Failure!
                        break;
                    }
                }
                
                wait_ms(1000);
            }
            else
            {
                printf("WiFi Connection Lost .... \r\n");
            }
            
            if ( pc.readable() )
            {
                pc.getc();
                break;
            }
        }
        
        ws.close();
        printf("Websocket Closed \r\n");
    }
}

// ------------------------------------------------------------------------------------------------------------
/*!
    @brief Open a TCP port send a string and wait for a reply
*/
// ------------------------------------------------------------------------------------------------------------
void TcpClientTest ( void )
{
uint16_t counter = 0;
TCPSocketConnection socket;
char buf[256];
int n = 0;
        
    if (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT_TCP) < 0) 
    {
        printf("Unable to connect to (%s) on port (%d)\r\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT_TCP);
    }
    else
    {
        // Block for 1 second
        socket.set_blocking( true, 1000 );
        
        printf("\r\n!! Press any key to stop sending !!\r\n\r\n");
        while (1)
        {   
            counter ++;
        
            n = socket.send_all(hello, sizeof(hello) - 1);
            
            if ( n > 0 )
            {
                printf("%05d : TCP Socket Sent : Hello World\r\n", counter);
            }
            else
            {
                printf("Failed to send\r\n");
                break;
            }
     
            n = socket.receive(buf, 256);
            
            if ( n > 0 )
            {
                printf("TCP Socket Recv'd : %s \r\n", buf);
                buf[n] = '\0';
            }
            else
            {
                buf[0] = '\0';
                printf("TCP : Failed to Recv\r\n");
                break;
            }
            
            wait_ms(50);
            
            // Should we stop?
            if ( pc.readable() )
            {
                pc.getc();
                break;
            }
        }
        if ( wifi.is_connected() )
        {
            socket.close();
        }
        printf("Completed.\r\n");
    }
}

// ------------------------------------------------------------------------------------------------------------
/*!
    @brief Opens a sockets to listen for connections, upon connection a message is sent and the 
           client disconnected
*/
// ------------------------------------------------------------------------------------------------------------
void TcpServerTest ( void )
{
int32_t status;
char buffer[256];
TCPSocketServer server;
TCPSocketConnection client;
    
    server.bind(15000);
    server.listen();
    printf("\r\n!! Press any key to stop listening !!\r\n\r\n");
    while (1) 
    {
        status = server.accept(client);
        if (status >= 0) 
        {
            client.set_blocking(false, 1500); // Timeout after (1.5)s
            printf("Connection from: %s \r\n", client.get_address());
            //client.receive(buffer, sizeof(buffer));
            //printf("Received: %s \r\n",buffer);
            printf("Sending the message to the server. \r\n");
            client.send_all(hello, sizeof(hello));
            client.close();
        }
        
        // Should we stop?
        if ( pc.readable() )
        {
            pc.getc();
            break;
        }
        
        if ( wifi.is_connected() )
        {
            break;
        }
    }
    
    if ( wifi.is_connected() )
    {
        server.close();
    }
}