#include "mbed.h"
#include "cc3000.h"
#include "wifi.h"

using namespace mbed_cc3000;

tUserFS cc_user_info;

const char * WIFI_STATUS[] = {"Disconnected", "Scanning", "Connecting", "Connected"};

/* cc3000 module declaration specific for user's board. Check also init() */
#if (MY_BOARD == WIGO)
cc3000 wifi(PTA16, PTA13, PTD0, SPI(PTD2, PTD3, PTC5), PORTA_IRQn);
#elif (MY_BOARD == WIFI_DIPCORTEX)
cc3000 wifi(p28, p27, p30, SPI(p21, p14, p37), PIN_INT0_IRQn);
#else

#endif

#ifndef CC3000_UNENCRYPTED_SMART_CONFIG
  const uint8_t smartconfigkey[] = {0x73,0x6d,0x61,0x72,0x74,0x63,0x6f,0x6e,0x66,0x69,0x67,0x41,0x45,0x53,0x31,0x36};
#else
  const uint8_t smartconfigkey = 0;
#endif

#if (MY_BOARD == WIGO)

#include "NVIC_set_all_priorities.h"

/**
 *  \brief Wi-Go initialization
 *  \param none
 *  \return none
 */
void init() {
    DigitalOut PWR_EN1(PTB2);
    DigitalOut PWR_EN2(PTB3);

    // Wi-Go set current to 500mA since we're turning on the Wi-Fi
    PWR_EN1 = 0;
    PWR_EN2 = 1;

    NVIC_set_all_irq_priorities(3);
    NVIC_SetPriority(SPI0_IRQn, 0x0);     // Wi-Fi SPI interrupt must be higher priority than SysTick
    NVIC_SetPriority(PORTA_IRQn, 0x1);
    NVIC_SetPriority(SysTick_IRQn, 0x2);  // SysTick set to lower priority than Wi-Fi SPI bus interrupt
    PORTA->PCR[16] |=PORT_PCR_ISF_MASK;
    PORTA->ISFR |= (1<<16);
}

#elif (MY_BOARD == WIFI_DIPCORTEX)

/**
 *  \brief Wifi DipCortex initialization
 *  \param none
 *  \return none
 */
void init() 
{
    NVIC_SetPriority(SSP1_IRQn, 0x0); 
    NVIC_SetPriority(PIN_INT0_IRQn, 0x1);
    
    // SysTick set to lower priority than Wi-Fi SPI bus interrupt
    NVIC_SetPriority(SysTick_IRQn, 0x2); 
}

#else

/**
 *  \brief Place here init routine for your board
 *  \param none
 *  \return none
 */
void init() {

}

#endif





/**
 *  \brief Print cc3000 information
 *  \param none
 *  \return none
 */
void print_cc3000_info() {
uint8_t myMAC[8];
uint8_t buffer[2];
int32_t status = 0;
tNetappIpconfigRetArgs ipinfo2;

    wifi.get_user_file_info((uint8_t *)&cc_user_info, sizeof(cc_user_info));
    wifi.get_mac_address(myMAC);
    printf(" MAC address : %02x:%02x:%02x:%02x:%02x:%02x\r\n", myMAC[0], myMAC[1], myMAC[2], myMAC[3], myMAC[4], myMAC[5]);
    
    if (! wifi._nvmem.read_sp_version( (unsigned char*)&buffer ) )
    {
        printf(" CC3000 Firmware Version : %u.%u \r\n", buffer[0], buffer[1]);
    }
    else
    {
        printf(" CC3000 Read nvmem failed!");
    }
    
    status = wifi._wlan.ioctl_statusget();
    if (( status > -1 ) && ( status < 4 ))
    {
        printf(" Wifi Status    : %s\r\n", WIFI_STATUS[status]);
    }
    else
    {
        printf(" Wifi Status    : %d\r\n", status);
    }
    
    if ( wifi.is_dhcp_configured() ) 
    {
        wifi.get_ip_config(&ipinfo2);
        printf(" Connected to   : %s \r\n", ipinfo2.uaSSID);
        printf(" IP             : %d.%d.%d.%d \r\n", ipinfo2.aucIP[3], ipinfo2.aucIP[2], ipinfo2.aucIP[1], ipinfo2.aucIP[0]);   
        printf(" Gateway        : %d.%d.%d.%d \r\n", ipinfo2.aucDefaultGateway[3], ipinfo2.aucDefaultGateway[2], ipinfo2.aucDefaultGateway[1], ipinfo2.aucDefaultGateway[0]);  
        printf(" Subnet         : %d.%d.%d.%d \r\n", ipinfo2.aucSubnetMask[3], ipinfo2.aucSubnetMask[2], ipinfo2.aucSubnetMask[1], ipinfo2.aucSubnetMask[0]);  
        printf(" DNS            : %d.%d.%d.%d \r\n", ipinfo2.aucDNSServer[3], ipinfo2.aucDNSServer[2], ipinfo2.aucDNSServer[1], ipinfo2.aucDNSServer[0]);  
        
        printf(" Cached IP      : %s \r\n", wifi.getIPAddress());   
        printf(" Cached Gateway : %s \r\n", wifi.getGateway());   
        printf(" Cached Subnet  : %s \r\n", wifi.getNetworkMask());   

    }
    else
    {
         printf(" Not connected \r\n");
    }

    // This doesn't work for the wifi dip
    printf(" FTC        %i\r\n",cc_user_info.FTC);
    printf(" PP_version %i.%i\r\n",cc_user_info.PP_version[0], cc_user_info.PP_version[1]);
    printf(" SERV_PACK  %i.%i\r\n",cc_user_info.SERV_PACK[0], cc_user_info.SERV_PACK[1]);
    printf(" DRV_VER    %i.%i.%i\r\n",cc_user_info.DRV_VER[0], cc_user_info.DRV_VER[1], cc_user_info.DRV_VER[2]);
    printf(" FW_VER     %i.%i.%i\r\n",cc_user_info.FW_VER[0], cc_user_info.FW_VER[1], cc_user_info.FW_VER[2]);
}

/**
 *  \brief Connect to SSID with a timeout
 *  \param ssid     Name of SSID
 *  \param key      Password
 *  \param sec_mode Security mode
 *  \return none
 */
void connect_to_ssid(char *ssid, char *key, unsigned char sec_mode) {
    printf("Connecting to SSID: %s. Timeout is 10s.\n",ssid);
    if (wifi.connect_to_AP((uint8_t *)ssid, (uint8_t *)key, sec_mode) == true) {
        printf(" Connected\r\n");
    } else {
        printf(" Connection timed-out (error). Please restart.\r\n");
        while(1);
  }
}

/**
 *  \brief Connect to SSID without security
 *  \param ssid Name of SSID
 *  \return none
 */
void connect_to_ssid(uint8_t *ssid) {
    wifi.connect_open((uint8_t *)ssid);
}

/**
 *  \brief First time configuration
 *  \param none
 *  \return none
 */
void do_FTC(void) 
{
/*
    printf("Running First Time Configuration\r\n");
    wifi.start_smart_config(smartconfigkey);
    while (wifi.is_dhcp_configured() == false) {
         wait_ms(500);
         printf("Waiting for dhcp to be set.\r\n");
    }
    cc_user_info.FTC = 1;
    wifi.set_user_file_info((uint8_t *)&user_info, sizeof(user_info));
    wifi._wlan.stop();
    printf("FTC finished.\r\n");
*/
}
