 
#include "mbed.h"
#include "cc3000.h"
#include "wifi.h"


#include "UDPSocket.h"

#include "NTPClient.h"
#include "tcpTests.h"
#include "main.h"

using namespace mbed_cc3000;

// TODO : List internal varibles & CC3000 buffers
// AP point scanning
// List open sockets
// Overkill mode 2 TCP 2 UDP echo ports?

Serial pc(p19, p20);
//Serial pc(USBTX, USBRX);

const int ECHO_SERVER_PORT_UDP = 81;
uint8_t *HostToPing = (uint8_t *)"google.com";
tNetappIpconfigRetArgs ipinfo;

MENU_LEVEL currentMenu = MENU_TOP;

// ------------------------------------------------------------------------------------------------------------
/*!
    @brief Resolve a hostname and ping it
*/
// ------------------------------------------------------------------------------------------------------------
void PingTest ( void )
{
uint32_t ip;
int32_t resolveRetCode = 0;
    
    printf("Get an IP address for %s\r\n",HostToPing);
    resolveRetCode = wifi._socket.gethostbyname(HostToPing,strlen((const char *)HostToPing), &ip);
    printf("gethostbyname Returned code : %i \r\n", resolveRetCode);
    
    if (resolveRetCode > -1) 
    {
        uint8_t add0 = (ip >> 24);
        uint8_t add1 = (ip >> 16);
        uint8_t add2 = (ip >> 8);
        uint8_t add3 = (ip >> 0);
        printf("IP address of %s: %d.%d.%d.%d \r\n", HostToPing, add0, add1, add2, add3);
        
        printf("Sending ping\r\n");
        uint32_t reply_count = wifi.ping(ip, 5, 500, 32);
        printf("Received %d replies\r\n", reply_count);
        printf("Ping complete.\r\n");
    } 
    else 
    {
        printf("Failed to resolve\r\n");
    }
}

// ------------------------------------------------------------------------------------------------------------
/*!
    @brief Test the NTP library
*/
// ------------------------------------------------------------------------------------------------------------
void NtpTest ( void )
{
NTPClient ntp;

    if (ntp.setTime("0.pool.ntp.org",123,10000) == 0)
    {
        printf("Set time successfully\r\n");
        time_t ctTime;
        ctTime = time(NULL);
        printf("Time is set to (UTC): %s\r\n", ctime(&ctTime));
    }
    else
    {
        printf("NTP Update Failed\r\n");
    } 
}

// ------------------------------------------------------------------------------------------------------------
/*!
    @brief Send a UDP Packet, wait for response
*/
// ------------------------------------------------------------------------------------------------------------
void UdpClientTest ( void )
{
UDPSocket socket;
char buf[256];
int n = 0;
Endpoint outEndpoint;
Endpoint inEndpoint;

    if (0 == socket.bind(ECHO_SERVER_PORT_UDP) )
    {
        
        // 2 second timeout
        socket.set_blocking(false, 2000);
        
        printf("\r\n!! Press any key to stop !!\r\n\r\n");
    
        while (1)
        {
            if( outEndpoint.set_address(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT_UDP) < 0 )
            {
                printf("Failed to set endpoint address.\r\n");
                break;
            }
            else if ( socket.sendTo( outEndpoint, hello, sizeof(hello) ) < 0 )
            {
                printf("Failed to send the packet.\r\n");
            }
            else
            {
                // Message sent, recv reply
                printf("UDP Socket Sent : %s \r\n", hello);   
                n = socket.receiveFrom( inEndpoint, buf, sizeof(buf) );
                if ( n < 0 )
                {
                    printf("Failed to recv the UDP packet.\r\n");
                }
                else
                {
                    buf[n] = '\0';
                    printf("UDP Socket Recv'd : %s \r\n", buf);    
                }
            }
    
            // Should we stop?
            if ( pc.readable() )
            {
                pc.getc();
                break;
            }
        }

        if ( wifi.is_connected() )
        {        
            socket.close();
        }
    }
    else
    {
        // Failed to bind to the socket
    }
}

// ------------------------------------------------------------------------------------------------------------
/*!
    @brief Listen on a UDP port for messages
*/
// ------------------------------------------------------------------------------------------------------------
void UdpServerTest ( void )
{
UDPSocket socket;
Endpoint client;
char buffer[256];
int n = 0;

    if (0 == socket.bind(ECHO_SERVER_PORT_UDP) )
    {   
        printf("\r\n!! Press any key to stop listening !!\r\n\r\n");
        
        while (true) 
        {
            printf("Waiting for packet...\r\n");
            n = socket.receiveFrom(client, buffer, sizeof(buffer));
        
            printf("Received packet from: %s\n", client.get_address());
            socket.sendTo(client, buffer, n);
        
            // Should we stop?
            if ( pc.readable() )
            {
                pc.getc();
                break;
            }
        }
    }
}

// ------------------------------------------------------------------------------------------------------------
/*!
    @brief Print menu header
*/
// ------------------------------------------------------------------------------------------------------------
void Menu_PrintHeader ( void )
{
    if (( wifi.is_enabled() ) && ( wifi.is_dhcp_configured() ))
    {
        wifi.get_ip_config(&ipinfo);
    }
    
    printf("\r\n");
    printf("+-------------------------------------------+\r\n");
    printf("|   WiFi DipCortex / CC3000 Kitchen Sink    |\r\n");
    printf("+-------------------------------------------+\r\n");
    if (! wifi.is_enabled() )
    {
        printf("|   CC3000 Disabled                         |\r\n"); 
    }
    else if ( wifi.is_dhcp_configured() ) 
    {
        printf("|   SSID : %-33s|\r\n", ipinfo.uaSSID);
        printf("|   IP : %-35s|\r\n", wifi.getIPAddress());   
    }
    else if ( wifi.is_connected() )
    {
        printf("|   Connecting, waiting for DHCP            |\r\n"); 
    }
    else
    {
        printf("|   Not Connected                           |\r\n");   
    }
    printf("+-------------------------------------------+\r\n");
    printf("\r\n");
}

// ------------------------------------------------------------------------------------------------------------
/*!
    @brief Control the wifi connection
*/
// ------------------------------------------------------------------------------------------------------------
char WaitForSerialCommand ( void )
{
char charIn = 0;
char prevCharIn;

    while (1)
    {
        prevCharIn = charIn;
        charIn = pc.getc();
        printf("%c", charIn);
        if ((charIn == '\n') || (charIn == '\r'))
        {
            break;
        }
    }
    
    return ( prevCharIn );
}

// ------------------------------------------------------------------------------------------------------------
/*!
    @brief Configure the module for smart connect mode allow configuration over the air
*/
// ------------------------------------------------------------------------------------------------------------
void SmartConfig ( void )
{
    // We dont want to auto reconnect to an access point
    wifi._wlan.ioctl_set_connection_policy(0, 0, 0);
    
    // start smart config will disconnect, set the prefix
    // wait for a message via a SmartConfig app, store it to the profile list
    // finally it will reenable auto connection, triggering the module to connect to the new access point
    wifi.start_smart_config(0);
}

// ------------------------------------------------------------------------------------------------------------
/*!
    @brief Control the wifi connection
*/
// ------------------------------------------------------------------------------------------------------------
void Menu_ConnectionControl ( void )
{
uint32_t ip = 0;
    Menu_PrintHeader();
    printf(" 1 - Enable auto connect to any previous access point\r\n");
    printf(" 2 - Disable auto connect \r\n");
    printf(" 3 - Connect to %s \r\n", SSID);
    printf(" 4 - Disconnect \r\n");
    printf(" 5 - Start SmartConfig \r\n");  
    printf(" 6 - Erase profiles \r\n");  
    printf(" 7 - Get Status \r\n");
    printf(" x - Top Menu \r\n");
    
    printf("\r\n");
    printf("Enter command character : ");
        
    switch(WaitForSerialCommand()) 
    {
        case '1':      
            wifi._wlan.ioctl_set_connection_policy(0, 1, 1);
        break;
        
        case '2':      
            wifi._wlan.ioctl_set_connection_policy(0, 0, 0);
        break;
        
        case '3':     
        
            //wifi.start(0);
            
            // Enable DHCP
            wifi._netapp.dhcp(&ip, &ip, &ip, &ip);
            
            if ( AP_SECURITY == NONE )
            {
                wifi.connect_non_blocking((uint8_t *)SSID, 0, AP_SECURITY);
            }
            else
            {
                printf("\r\n Connecting to : %s key : %s", SSID, AP_KEY );
                wifi.connect_non_blocking((uint8_t *)SSID, (uint8_t *)AP_KEY, AP_SECURITY);
                
            }      
        break;
        
        case '4' :
            // Stop the module re-connecting
            wifi._wlan.ioctl_set_connection_policy(0, 0, 0);
            // Then disconnect
            wifi.disconnect();
        break;
        
        case '5' :
            SmartConfig();
        break;
        
        case '6' :
            wifi._wlan.ioctl_del_profile(255);
        break;
        
        case '7' :
            print_cc3000_info();
        break;
        
        case '8':
            //wifi._spi.manualIrqCheck();
        break;
        
        case 'x':      
            currentMenu = MENU_TOP;
        break;
    }
}

// ------------------------------------------------------------------------------------------------------------
/*!
    @brief 
*/
// ------------------------------------------------------------------------------------------------------------
void Menu_UdpControl ( void )
{
    Menu_PrintHeader();

    printf(" 1 - UDP Client, Connect to %s:%d\r\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT_UDP);
    printf(" 2 - UDP Server \r\n");
    printf(" 3 - NTP Client \r\n");
    printf(" x - Exit to top menu \r\n");
    
    printf("\r\n");
    printf("Enter command character : ");
    
    switch(WaitForSerialCommand())  
    {
        case '1':      
            UdpClientTest();
        break;
        case '2':      
            UdpServerTest();
        break;
        case '3':      
            NtpTest();
        break;
        case 'x':      
            currentMenu = MENU_TOP;
        break;
    }
}

// ------------------------------------------------------------------------------------------------------------
/*!
    @brief 
*/
// ------------------------------------------------------------------------------------------------------------
void Menu_TcpControl ( void )
{
    Menu_PrintHeader();

    printf(" 1 - TCP Client, Connect to %s:%d\r\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT_TCP);
    printf(" 2 - TCP Server, listen on %d.%d.%d.%d:%d\r\n", ipinfo.aucIP[3], ipinfo.aucIP[2], ipinfo.aucIP[1], ipinfo.aucIP[0], ECHO_SERVER_PORT_TCP);
    printf(" 3 - Web Socket Write \r\n");
    printf(" 4 - Web Socket Read \r\n");
    printf(" 5 - HTTP Client \r\n");
    printf(" x - Exit to top menu ");
    printf("\r\n");
    printf("Enter command character : ");
    
    switch(WaitForSerialCommand()) 
    {
        case '1':      
            TcpClientTest();
        break;
        case '2':      
            TcpServerTest();
        break;
        case '3':      
            WebSocketTest();
        break;
        case '4':
        
        break;
        case '5':
            HttpClientTest();
        break;
        case 'x':      
            currentMenu = MENU_TOP;
        break;
    }
}


// ------------------------------------------------------------------------------------------------------------
/*!
    @brief Display a menu to the user
*/
// ------------------------------------------------------------------------------------------------------------
void Menu_Top ( void )
{
    Menu_PrintHeader();
    
    printf(" 1 - Connection control menu \r\n" );
    printf(" 2 - TCP test menu \r\n" );
    printf(" 3 - UDP test menu \r\n" );
    printf(" 4 - Connection status \r\n");
    printf(" 5 - Ping - %s \r\n", HostToPing);
    printf(" x - Top Menu \r\n");
    
    printf("\r\n");
    printf("Enter command character : ");
 
    switch(WaitForSerialCommand()) 
    {
        case '1':      
            currentMenu = MENU_CONNECTION;
        break;
        case '2':      
            currentMenu = MENU_TCP;
        break;
        case '3':      
            currentMenu = MENU_UDP;
        break;
        case '4':      
            print_cc3000_info();
        break;
        case '5':      
            PingTest();
        break;
        case 'x':      
            currentMenu = MENU_TOP;
        break;
    }
}

// ------------------------------------------------------------------------------------------------------------
/*!
    @brief Pick which menu to display
*/
// ------------------------------------------------------------------------------------------------------------
void MenuSwitch ( void )
{
bool connected = false;

    if ( wifi.is_dhcp_configured() )
    {
        connected = true;
    }
    
    switch ( currentMenu )
    {
        case MENU_TOP :
            Menu_Top();
        break;
        
        case MENU_CONNECTION :
            Menu_ConnectionControl();
        break;
        
        case MENU_TCP :
            if (connected) 
            {
                Menu_TcpControl();
            }
            else
            {
                currentMenu = MENU_TOP;
            }
        break;
        
        case MENU_UDP :
            if (connected) 
            {
                Menu_UdpControl();
            }
            else
            {
                currentMenu = MENU_TOP;
            }
        break;
        
        default :
            printf("Unknown command\r\n");
        break;
    }
}

// ------------------------------------------------------------------------------------------------------------
/*!
    @brief main loop
*/
// ------------------------------------------------------------------------------------------------------------
int main( void ) 
{   
    // Initalise the WiFi Module
    init(); 
    
    pc.baud(SERIAL_BAUD_RATE);
    
    wait(1);
    wifi.start(0);
    
    wait_ms(750);

    while (1)
    {
        MenuSwitch();
    }
}
