#define USER_START_SECTOR       SECTOR_2_START

#ifndef  _SBL_IAP_H
#define  _SBL_IAP_H


#define SECTOR_0_START          0x00000000
#define SECTOR_1_START          0x00001000
#define SECTOR_2_START          0x00002000
#define SECTOR_3_START          0x00003000
#define SECTOR_4_START          0x00004000
#define SECTOR_5_START          0x00005000
#define SECTOR_6_START          0x00006000
#define SECTOR_7_START          0x00007000
#define SECTOR_8_START          0x00008000
#define SECTOR_9_START          0x00009000
#define SECTOR_10_START         0x0000A000
#define SECTOR_11_START         0x0000B000
#define SECTOR_12_START         0x0000C000
#define SECTOR_13_START         0x0000D000
#define SECTOR_14_START         0x0000E000
#define SECTOR_15_START         0x0000F000


#define SECTOR_0_END            0x00000FFF
#define SECTOR_1_END            0x00001FFF
#define SECTOR_2_END            0x00002FFF
#define SECTOR_3_END            0x00003FFF
#define SECTOR_4_END            0x00004FFF
#define SECTOR_5_END            0x00005FFF
#define SECTOR_6_END            0x00006FFF
#define SECTOR_7_END            0x00007FFF
#define SECTOR_8_END            0x00008FFF
#define SECTOR_9_END            0x00009FFF
#define SECTOR_10_END           0x0000AFFF
#define SECTOR_11_END           0x0000BFFF
#define SECTOR_12_END           0x0000CFFF
#define SECTOR_13_END           0x0000DFFF
#define SECTOR_14_END           0x0000EFFF
#define SECTOR_15_END           0x0000FFFF

#define CCLK 72000              /* 72,000 KHz for IAP call WiFI Dip and M3 - TODO : Addjust for M0*/

#define FLASH_BUF_SIZE          256
#define SECTOR_0_START_ADDR     0
#define SECTOR_SIZE             4096
#define MAX_USER_SECTOR         16
#define PAGES_PER_SECTOR        16

//extern const unsigned sector_start_map[];
//extern const unsigned sector_end_map[];
extern const unsigned crp;

unsigned write_flash(unsigned * dst, char * src, unsigned no_of_bytes);
void erase_user_flash(void);
void IAP_Init(void);
int IAP_CheckForUserCode(void);
int IAP_WritePage (unsigned * dst, char * src, unsigned no_of_bytes);
void IAP_Eeprom_Write ( uint32_t eeAddress, uint8_t* buffAddress, uint32_t byteCount );
void IAP_Eeprom_Read ( uint32_t eeAddress, uint8_t* buffAddress, uint32_t byteCount );

typedef enum
{
PREPARE_SECTOR_FOR_WRITE=50,
COPY_RAM_TO_FLASH=51,
ERASE_SECTOR=52,
BLANK_CHECK_SECTOR=53,
READ_PART_ID=54,
READ_BOOT_VER=55,
COMPARE=56,
REINVOKE_ISP=57,
ERASE_PAGE=59,
EEPROM_WRITE=61,
EEPROM_READ=62,

}IAP_Command_Code;

#define CMD_SUCCESS 0
#define IAP_ADDRESS 0x1FFF1FF1

#define UPDATE_REQD 133

#endif /* _SBL_IAP_H */
