#include "mbed.h"
#include "SDFileSystem.h"
#include "BMP180.h"
#include "ds3231.h"

SDFileSystem sd(p5, p6, p7, p12, "sd");
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
I2C i2(p9,p10);
BMP180 bmp(&i2);
AnalogIn bat(p20);
Serial xbee(p13,p14);
Ds3231 rtc(p9,p10);

//constantes
const int addra = 0x32;
enum REG_ADDRS {
    CTRL_REG1_A = 0x20,//decir que ejes quiero habilitar y a que frecuencia
    CTRL_REG4_A = 0x23,//para la escala
    OUT_X_A     = 0x28,
    OUT_Y_A     = 0x2A,
    OUT_Z_A     = 0x2C,
};

//variables
Ticker vel;
Timer t;
time_t epoch_time;
char time1[3],fecha[18],nombre[30],acc[6],dato1[100],dato2[11];
int seg1, seg2=-1, milis,cel, i=0,ax,ay,az,en=0;
float temp;
FILE *fp;

bool writer(int i2cdir,int addr, char valor) // para escribir en el i2c
{
    char data[2] = {addr, valor}; 
    return i2.write(i2cdir, data, 2) == 0;
}

void configAcel()//para configurar el acelerometro
{
    i2.frequency(200000);
    char regv;
    regv = 0; //Se inicializa la variable
    regv |= 0x77;          //X/Y/Z axis enable y a 400Hz/
    writer(addra,CTRL_REG1_A,regv);
    regv = 0; 
    regv |= 0x08;          //2g a high resolution
    writer(addra,CTRL_REG4_A,regv);
}

bool recv(char sad, char sub, char *buf, int length) {
    if (length > 1) sub |= 0x80;
 
    return i2.write(sad, &sub, 1, true) == 0 && i2.read(sad, buf, length) == 0;
}

bool aclect(int *ax, int *ay, int *az, char acc[6]) {
    if (recv(addra, OUT_X_A, acc, 6)) {
        *ax = short(acc[1] << 8 | acc[0]);  //32768/4=8192
        *ay = short(acc[3] << 8 | acc[2]);
        *az = short(acc[5] << 8 | acc[4]);        
        return true;
    }
    return false;
}

void almacenamiento(char dat[])
{
    if(i==0)//Archivo de crear la rutina
    {   
        strftime(nombre,30,"/sd/%y%m%d_%H%M%S.txt", localtime(&epoch_time));
        fp= fopen(nombre, "a+");
        if(fp == NULL) error("Could not open file for write\n");
        
    }
    
    fprintf(fp,dat);
    fprintf(fp,"\n");
    i++;
    if(i==6000)//Para cerrar el archivo
    {
        fclose(fp);
        i=0;
        led2=!led2;
          
    } 
}

void lectura()//para la captura de datos
{
    //lectura del reloj
    epoch_time = rtc.get_epoch();
    strftime(fecha, 19, "%d/%m/%y\t%H:%M:%S", localtime(&epoch_time));
    strftime(time1,3,"%S", localtime(&epoch_time));
    
    seg1=atoi(time1);
    if(seg1 !=  seg2){seg2=seg1;t.stop(); t.reset();t.start();}
    milis=t.read_ms();

    //Sensor de temperatura
    bmp.startTemperature();
    if(bmp.getTemperature(&temp) != 0) 
        printf("Error al tomar la temperatura");
    cel=int(temp); 
    
    //acelerometro 
    aclect(&ax, &ay, &az, acc);
    
    //almacenamiento
    sprintf(dato1,"%d\t%d\t%d\t%d\t%s\t%d",ax,ay,az,cel,fecha,milis);
    almacenamiento(dato1);
        
}


int main()
{
    led1=0;
    led2=0;
    led3=0;
    led4=0;
    //configuraciones
    xbee.baud(115200);
    bmp.init();
    configAcel();

    vel.attach(&lectura,0.008);
    
    while(1)
    {
        led1!=led1;
        wait(0.5);
    }  
}