#include "mbed.h"

PwmOut led(LED1); // led 1 indicates dim value
DigitalOut led2(LED2); // led 2 indicates delay time for interrupts

DigitalOut SSR(p27);
Serial pc(p9,p10);
Timeout SSRtriggerOn;
DigitalOut foco(p16);
DigitalOut motor(p17);
DigitalOut elec(p20);
Ticker cruce;

volatile float dim;
const float powerlinefrequency=60.000;

void triggerOn()
{
    SSR = 1;
    led2=0;
}

 void dimmer()
{
    // turn off SSR at zero crossing
    SSR = 0;
    // compute time delay using dim value and set timer interrupt
    // triggers SSR after a small post zero crossing time delay
    SSRtriggerOn.attach(&triggerOn,(dim)/(2*powerlinefrequency));
    led2=1;
}

int main()
{
    cruce.attach(&dimmer, 0.00833333);
    foco=0;
    motor=0;
    elec=0;
    
    float m;
    //set up interrupt routine to detect AC line zero crossings
   
    m=180;
    // main program only sets dimmer level (dim)
    // interrupt routines dim the light
    while(1) {
        char da=pc.getc();
        //increase brightness
        if(da=='y')
        {
            if(m<180)m=m+5;
        }
        if(da=='x')
        {
            if(m>0)m=m-5;
        }
        dim=m/180+0.001;
        if(da=='c')foco=1;
        if(da=='d')foco=0;
        if(da=='a')motor=1;
        if(da=='b')motor=0;
        if(da=='e')elec=1;
        if(da=='f')elec=0;
        printf("\n\rGrados: %f, %c",m,da);
        
    }
}   