#include "mbed.h"
#include "ds3231.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"


AnalogIn x(p20);
AnalogIn y(p19);
AnalogIn z(p18);
AnalogIn bat1(p17);
AnalogIn bat2(p16);
Ds3231 rtc(p28,p27);
Serial pc(USBTX,USBRX);
DigitalOut led2(LED2);
SDBlockDevice sd(p5, p6, p7, p8); 
FATFileSystem fs("fs");
Serial xbee(p13,p14);

Ticker Lectura;

Timer t;
time_t epoch_time;
char time1[3],fecha[18],nombre[30],dato1[100],dato[13];
int seg1, seg2=-1, milis,cel=25, en=0;
unsigned short ax,ay,az;
int b1, b2;


float temp;
FILE *fp;
int i=0;


void envio()
{
    int r=0;//para el checsum
    for(int j=0;j<strlen(dato);j++)
    {
        r=r+int(dato[j]);
        
    }
    r=r+927;//esto se modifica segun los valores del coordinador
    if(r>4095) r=r%4096;
    if(r>255)  r=r%256;
    int t=255-r;
    
    //para el tamano
    int q=14+strlen(dato);
    int z=int(q/256);
    int x=int(q%256);

    xbee.putc(0x7E);
    xbee.putc(char(z));
    xbee.putc(char(x));
    xbee.putc(0x10);
    xbee.putc(0x00);
    xbee.putc(0x00);
    xbee.putc(0x13);
    xbee.putc(0xA2);
    xbee.putc(0x00);
    xbee.putc(0x41);
    xbee.putc(0x02);
    xbee.putc(0x01);
    xbee.putc(0x99);
    xbee.putc(0xFF);
    xbee.putc(0xFE);
    xbee.putc(0x00);
    xbee.putc(0x00);
    xbee.putc(dato[0]);
    xbee.putc(dato[1]);
    xbee.putc(dato[2]);
    xbee.putc(dato[3]);
    xbee.putc(dato[4]);
    xbee.putc(dato[5]);
    xbee.putc(dato[6]);
    xbee.putc(dato[7]);
    xbee.putc(char(t));
    
}

void Lect()
{
        ax=x.read_u16();
        ay=y.read_u16();
        az=z.read_u16();
        b1 = (int)(bat1.read()*100.0f);
        b2 = (int)(bat2.read()*100.0f);
        
        epoch_time = rtc.get_epoch();
        strftime(fecha, 19, "%d/%m/%y\t%H:%M:%S", localtime(&epoch_time));
        strftime(time1,3,"%S", localtime(&epoch_time));
    
        seg1=atoi(time1);
        if(seg1 !=  seg2){seg2=seg1;t.stop(); t.reset();t.start();}
        milis=t.read_ms();

        //Sensor de temperatura
        /*int b=0;
        if(b1<b2)
            b=b1/10;
        else
            b=b2/10;*/
    
        sprintf(dato1,"%d\t%d\t%d\t%s\t%d\n",ax,ay,az,fecha,milis);   
        //sprintf(dato,"%c%c%c%c%c%c%c%c",(int)(ax/256),(int)(ax%256),(int)(ay/256),(int)(ay%256),(int)(az/256),(int)(az%256),(b),(char)((int)(milis/10)));
        //envio();
        if(i==0)//Archivo de crear la rutina
    {   
        strftime(nombre,30,"/fs/%y%m%d_%H%M%S.txt", localtime(&epoch_time));
        fp= fopen(nombre, "a+");
        if(fp == NULL) error("Could not open file for write\n");
    }
    
    fprintf(fp,dato1);

    i++;
    if(i==6000)//Para cerrar el archivo
    {
        fclose(fp);
        i=0;
        led2=!led2;
    }
        
    
}

int main()
{
    sd.init();
    fs.mount(&sd);
    xbee.baud(115200);
    Lectura.attach(&Lect,0.01);
    while(1)
    {}
    sd.deinit();
    fs.unmount();
}