#ifndef SMART_PLUG_BLE_H
#define SMART_PLUG_BLE_H

#include "SmartPlug.h"
#include "MVC.h"
#include "mbed.h"
#include "SPCommunication.h"
#include <vector>


class SmartPlugBLE: public Observable
{
public:
    SmartPlugBLE():counter(60),led(LED3,0)
     {
        ticker.attach(this,&SmartPlugBLE::periodicCallback, 1); // blink LED every second
    }

    void onRelayWrite(const uint8_t *data)
     {
        counter = 60;
        updateRelay(data);
        notifyObservers();
    }

    void updateRelay(const uint8_t *data) 
    {
        uint8_t state = data[0]>>7;
        uint8_t hour = data[0]&0x7F;
        uint8_t min = data[1];
        //instant behavior
        if(state)
        {
            printf("Open!\r\n");
            led = 0;
        }
        else if(!state && hour == 0 && min == 0)
        {
            printf("Close!\r\n");
            led = 1;
        }
        //
        smartPlug.setRelay(state,hour,min);
    }

    void notifyObservers()
     {
        for(int i=0; i<observers.size(); i++) 
        {
            observers[i]->updateObserver((void*)&smartPlug);
        }
    }

    void addObserver(Observer* o) 
    {
        observers.push_back(o);
    }

    void periodicCallback(void)
     {
        if(smartPlug.isCounting)
         {
            counter--;
             if(counter > 60) 
            {
                smartPlug.getRelay()->setMinCounter(smartPlug.getRelay()->getMinCounter()-1);
                if(smartPlug.getRelay()->getMinCounter() == 0) 
                {
                    smartPlug.getRelay()->setHrCounter(smartPlug.getRelay()->getHrCounter()-1);
                    smartPlug.getRelay()->setMinCounter(0);
                }
                if(smartPlug.getRelay()->getHrCounter() >128) 
                {
                    smartPlug.getRelay()->setHrCounter(0);
                    //spComm.setRelay(smartPlug.getRelay()->getState());
                    if(smartPlug.getRelay()->getState())
                        printf("Open!\r\n");
                    else
                    {
                        printf("Close!\r\n");
                        led = 1;
                        smartPlug.isCounting = false;
                    }
                }
                counter = 60;
            }
        }
        else
            counter = 60;
    }

    void updateData(void) {
        spComm.SPUart.printf("in update section");
        smartPlug.setVoltage/*(smartPlug.getVoltage()+1);*/(spComm.getVoltage());
        spComm.SPUart.printf("out update section");
        //smartPlug.setCurrent/*(smartPlug.getCurrent()+1);*/(spComm.getCurrent());
        //smartPlug.setPower/*(smartPlug.getPower()+1);*/(spComm.getPower());
        //smartPlug.setPowerFactor/*(smartPlug.getPowerFactor()+1);*/(spComm.getPowerFactor());
        //smartPlug.setEnergy/*(smartPlug.getEnergy()+1);*/(spComm.getEnergy());
        //smartPlug.getRelay()->setState(spComm.getRelay());
        notifyObservers();
    }
    
    SmartPlug getSmartPlug()
    {
        return smartPlug;
    }
    
    uint8_t getCounter()
    {
        return counter;
    }
    
    void setCounter(uint8_t val)
    {
        counter = val;
    }
private:
    SmartPlug smartPlug;
    Ticker ticker;
    uint8_t counter;
    DigitalOut led;
    SPCommunication spComm;
    //BLECommunication bleComm;
    vector<Observer*> observers;
};

#endif