#include "BLECommunication.h"


BLECommunication::BLECommunication(SmartPlugBLE& system,BLE &_ble):
    ble(_ble),smartPlugService(ble,system)
{

    ble.init();
    ble.gattServer().onDataWritten(&smartPlugService,&SmartPlugService::onDataWritten);
    smartPlugService.setupService();
    start();
}

void BLECommunication::start(void)
{
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t*)list, sizeof(list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::UNKNOWN);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));//cannot blink after this

    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(1000); /* 1000ms */

    ble.gap().startAdvertising();
    while(true)
    {
        ble.waitForEvent();
    }
}