#ifndef SP_SERVICE_H
#define SP_SERVICE_H

#include "ble/BLE.h"
#include "MVC.h"
#include "mbed.h"
#include "SmartPlugBLE.h"


#define FULL_UUID(uuid_16) {        \
    0x9B,0x3F,uuid_16>>16,uuid_16&0xFF,0x65,0x80,0x47,0x51, \
    0xB0,0x2F,0xA7,0xB5,0x19,0x4C,0x7F,0x23     \
    }

static const uint16_t SPS_UUID_SERVICE = 0x1522;
static const uint16_t SPS_UUID_VOLTAGE_CHAR = 0x1523;
static const uint16_t SPS_UUID_CURERNT_CHAR = 0x1524;
static const uint16_t SPS_UUID_POWER_CHAR = 0x1525;
static const uint16_t SPS_UUID_POWER_FACTOR_CHAR = 0x1526;
static const uint16_t SPS_UUID_ENERGY_CHAR = 0x1527;
static const uint16_t SPS_UUID_RELAY_CHAR = 0x1528;
static const uint16_t SPS_UUID_UPDATE_CHAR = 0x1529;

static const uint8_t SPS_UUID_SERVICE_FULL[] = FULL_UUID(SPS_UUID_SERVICE);
static const uint8_t SPS_UUID_VOLTAGE_CHAR_FULL[] = FULL_UUID(SPS_UUID_VOLTAGE_CHAR);
static const uint8_t SPS_UUID_CURERNT_CHAR_FULL[] = FULL_UUID(SPS_UUID_CURERNT_CHAR);
static const uint8_t SPS_UUID_POWER_CHAR_FULL[] = FULL_UUID(SPS_UUID_POWER_CHAR);
static const uint8_t SPS_UUID_POWER_FACTOR_CHAR_FULL[] = FULL_UUID(SPS_UUID_POWER_FACTOR_CHAR);
static const uint8_t SPS_UUID_ENERGY_CHAR_FULL[] = FULL_UUID(SPS_UUID_ENERGY_CHAR);
static const uint8_t SPS_UUID_RELAY_CHAR_FULL[] = FULL_UUID(SPS_UUID_RELAY_CHAR);
static const uint8_t SPS_UUID_UPDATE_CHAR_FULL[] = FULL_UUID(SPS_UUID_UPDATE_CHAR);


class SmartPlugService: public Observer
{
public:
    SmartPlugService(BLE &_ble, SmartPlugBLE &sys);
    
    void updateVoltage(uint32_t value);
    void updateCurrent(uint32_t value);
    void updatePower(uint32_t value);
    void updatePowerFactor(uint32_t value); 
    void onDataWritten(const GattWriteCallbackParams *params);
    void updateObserver(void* data);    
    void updateRelay(Relay* relay);
    void updateEnergy(uint32_t value);
    void setupService(void);
private:
    class RelayValueBytes
    {
        public:
            static const uint8_t MAX_SIZE_BYTES = 2;
            static const uint8_t STATE_BIT_INDEX = 7;
            static const uint8_t STATE_BYTE_INDEX = 0;
            static const uint8_t HOUR_TIMER_BYTE_INDEX = 0;
            static const uint8_t MINUTE_TIMER_BYTE_INDEX = 1;
            
            RelayValueBytes()
            {
                memset(data,0,MAX_SIZE_BYTES);
            }
            
            void updateData(Relay* relay)
            {
                printf("updateData:: min = %d,hour = %d,state = %d\r\n",relay->getMinCounter(),relay->getHrCounter(),relay->getState());
                data[STATE_BYTE_INDEX] |= ((relay->getState())<<STATE_BIT_INDEX);
                data[HOUR_TIMER_BYTE_INDEX] |= relay->getHrCounter();
                data[MINUTE_TIMER_BYTE_INDEX] = relay->getMinCounter();
            }
            
            void swap(uint8_t* ptr1,uint8_t* ptr2)
            {
                uint8_t temp;
                temp = *ptr1;
                *ptr1 = *ptr2;
                *ptr2 = temp;
            }
            
            void reverse(uint8_t* ptr)
            {
                swap(&ptr[0],&ptr[1]);
            }
            
            uint8_t* getDataPointer()
            {
                //reverse(data);
                return data;
            }
            
            uint8_t getLenBytes()
            {
                if(data[HOUR_TIMER_BYTE_INDEX] == 0 && data[MINUTE_TIMER_BYTE_INDEX] == 0)
                    return 1;
                else
                    return MAX_SIZE_BYTES;
            }
        private:
            uint8_t data[MAX_SIZE_BYTES];
    };

    BLE ble;
    DigitalOut led;
    
    uint8_t voltage[4];
    uint8_t current[4];
    uint8_t power[4];
    uint8_t powerFactor[4];
    uint8_t energy[4];

    RelayValueBytes relayValue;
    //uint8_t updateValue;
    SmartPlugBLE& system;
    
    ReadOnlyGattCharacteristic<uint8_t[4]> voltageChar;
    ReadOnlyGattCharacteristic<uint8_t[4]> currentChar;
    ReadOnlyGattCharacteristic<uint8_t[4]> powerChar;
    ReadOnlyGattCharacteristic<uint8_t[4]> powerFactorChar;
    ReadOnlyGattCharacteristic<uint8_t[4]> energyChar;
    GattCharacteristic relayChar;
    WriteOnlyGattCharacteristic<uint8_t> updateChar;
};

#endif