#ifndef SMART_PLUG_H
#define SMART_PLUG_H


class Relay
{
    public:
        Relay():state(0),hrCounter(0),minCounter(0)
        {
        }
        
        void setState(uint8_t newState)
        {
            state = newState;
        }
        
        void setHrCounter(uint8_t newHrCounter)
        {
            hrCounter = newHrCounter;   
        }
        
        void setMinCounter(uint8_t newMinCounter)
        {
            minCounter = newMinCounter;   
        }
        
        uint8_t getState()
        {
            return state;
        }
        
        uint8_t getHrCounter()
        {
            return hrCounter;
        }
        
        uint8_t getMinCounter()
        {
            return minCounter;
        }
        
    private:
        uint8_t state;
        uint8_t hrCounter;
        uint8_t minCounter;
};

class SmartPlug
{
    public:
        bool isCounting;
        
        SmartPlug():isCounting(false),voltage(0),current(0),power(0),powerFactor(0),energy(0)
        {
        }
        
        uint32_t getVoltage()
        {
            return voltage;
        }
        
        uint32_t getCurrent()
        {
            return current;
        }
        
        uint32_t getPower()
        {
            return power;
        }
        
        uint32_t getPowerFactor()
        {
            return powerFactor;
        }
        
        uint32_t getEnergy()
        {
            return energy;
        }
            
        Relay* getRelay()
        {
            return &relay;
        }
        
        void setVoltage(uint32_t data)
        {
            voltage = data;
        }
        
        void setCurrent(uint32_t data)
        {
            current = data;
        }
        
        void setPower(uint32_t data)
        {
            power = data;
        }
        
        void setPowerFactor(uint32_t data)
        {
            powerFactor = data;
        }
        
        void setEnergy(uint32_t data)
        {
            energy = data;
        }
        
        void setRelay(uint8_t state,uint8_t hour, uint8_t min)
        {
            relay.setState(state);
            relay.setHrCounter(hour);
            relay.setMinCounter(min);
            printf("hour = %d,min = %d\r\n",hour,min);
            if(hour != 0 || min != 0)
                isCounting = true;
            else if(state)
            {
                isCounting = false;
            }
        }
    private:
        uint32_t voltage;
        uint32_t current;
        uint32_t power;
        uint32_t powerFactor;
        uint32_t energy;
        Relay relay;
};

#endif