#include "SPCommunication.h"

SPCommunication::SPCommunication():SPUart(p9,p11)
{
    SPUart.baud(115200);
    SPUart.attach(this,&SPCommunication::Rxint,Serial::RxIrq);
    size=0;
    r = 0;
    w = 0;
    for (int i=0;i<128;i++) RxBuffer[i]=0;
}    
SPCommunication::SPCommunication(PinName tx,PinName rx,uint32_t bRate): SPUart(tx,rx){

    SPUart.baud(bRate);
     SPUart.attach(this,&SPCommunication::Rxint,Serial::RxIrq);
    size=0;
    r = 0;
    w = 0;
    for (int i=0;i<128;i++) RxBuffer[i]=0;
    
}
void SPCommunication::Rxint()
{
 // SPUart.putc(SPUart.getc());
 
    while (SPUart.readable()){
    uint8_t temp = SPUart.getc();
    //buff.addData(temp);
    RxBuffer[w] = temp;
    if (++w >= 128) 
        w = 0;
    }
}
//Get crc remainder from table
uint8_t SPCommunication::getCRC(uint8_t val)
{ 
    return crc8_table[val];   
}

// print all data store in ArrData in class
void SPCommunication::printData(){
    //SPUart.printf("szie is %02X ",size);
    for(int i=0;i<size;i++)
        SPUart.printf("%02X ",DataArr[i]);
    }


uint8_t* SPCommunication::RequestData(uint8_t* data)
{
 
 int i=0;
    do // Send request Data
    {
    SPUart.printf("%c",data[i]);  
    i++; 
    }
    while(data[i]!='\0');
    wait(1);
    uint8_t temp = readData();
    //SPUart.printf("\r\n in int %02x",temp);
    
    if((uint8_t) temp == 0x7E){
       uint8_t err = handleData();
       if(err)
            handleData();
    }

  return 0;
    
}


uint8_t SPCommunication::handleData(){
    delete[] DataArr;
    
    uint8_t message;
    uint8_t crccheck;
    
    size=readData();
    //size/=2;
 //   SPUart.printf("\r\n Size is  %02X",size);
    DataArr = new uint8_t[size];
    uint8_t test[size+1];
    test[0]=size;
    for (uint8_t i=0;i<size;i++)
    {
           
            message = readData();
             test[i+1]=(uint8_t) message;
             DataArr[i] = (uint8_t) message;
            
   //         SPUart.printf("\r\n bool Data is %d value in table %d value in ctc check %d" ,message,crc8_table[message],crccheck  );
            
    }
//    printf("arr Data");
//    for (int i=0;i<size;i++)
//        printf("%02X ",DataArr[i]);
    
    crccheck=DataArr[size-1];

    //printf( "\r\n val crc in arr is %02X recall fn val  ",crccheck );
    if( crccheck == (uint8_t) crc8Compute(test,size) )
        {
                //SPUart.printf("hi");
               SPUart.printf("\r\nComplete");
                
     //         SPUart.printf("\r\nin crc fask condition %02X add to arrData",DataArr[i]);
               // sum+=DataArr[i];
        }
    else
        {
            SPUart.printf("\r\nfail");
                return 1;    
                
        }   
    
    return 0;
}

//***********************************************************************************************************************************
    //Getter method for request information abour uart
//***********************************************************************************************************************************

uint32_t SPCommunication::getVoltage()
{
    uint8_t com[2]={0x02,0x56};
    uint8_t command[4] = {0x7E,0x02,0x56,(uint8_t) crc8Compute(com,2)};
    RequestData(command);
     uint32_t Recv ;
    //crc8Compute(com,2);
    memcpy(&Recv,DataArr,32);
    
    
    return Recv;
    //printData();

}
uint32_t SPCommunication::getEnergy()
{  
    uint8_t com[2]={ 0x02,'E'};
    uint8_t command[4] = {0x7E,0x02,'E',(uint8_t) crc8Compute(com,2)};
    
}
uint32_t SPCommunication:: getCurrent()
{
    uint8_t com[2]={ 0x02,'I'};
    uint8_t command[4] = {0x7E,0x02,'I',(uint8_t) crc8Compute(com,2)};
    RequestData(command);
     uint32_t Recv ;
    //crc8Compute(com,2);
    memcpy(&Recv,DataArr+1,32);
    return Recv;
}


uint32_t  SPCommunication::getPower()
{
    uint8_t com[2]={ 0x02,'P'};
    uint8_t command[4] = {0x7E,0x02,'P',(uint8_t) crc8Compute(com,2)} ;
    RequestData(command);
    
     uint32_t Recv ;
    //crc8Compute(com,2);
    memcpy(&Recv,DataArr+1,32);
    return Recv;
}

uint32_t  SPCommunication::getPowerFactor()
{
    uint8_t com[2]={ 0x02,'C'};
    uint8_t command[4] = {0x7E,0x02,'C',(uint8_t) crc8Compute(com,2) };
    RequestData(command);
     uint32_t Recv ;
    //crc8Compute(com,2);
    memcpy(&Recv,DataArr+1,32);
    return Recv;
    
}

bool SPCommunication::getStateRelay()
{
    uint8_t com[2]={ 0x02,'S'};
    uint8_t command[4] = {0x7E,0x02,'S',(uint8_t) crc8Compute(com,2) };
    RequestData(command);
    
    return DataArr[1];
}

bool SPCommunication::setStateRelay(uint8_t st)
{
    uint8_t* command;
    if (st ==1){
    uint8_t com[3]={ 0x03,'S',0x01};

     uint8_t temp[] = {0x7E,0x03,'S',0x01,(uint8_t) crc8Compute(com,2) };
     command=temp;
    }
    else{
    uint8_t com[3]={ 0x03,'S',0x00};
     uint8_t temp[] = {0x7E,0x03,'S',0x00,(uint8_t) crc8Compute(com,2) };
     command=temp;
    }
    RequestData(command);
    if(DataArr[0] == command[2] && DataArr[1] == command[3] )
        return true;
    
    return false;
        
}
uint8_t SPCommunication::readData()
{
    
    uint8_t temp=RxBuffer[r];
//    if (temp == 0)
//        return 0;
    r++;
    if(r>=128)
        r=0;
    return temp;
    
}
