#ifndef DAC_H
#define DAC_H
 
#include "mbed.h"
#include "MCP4725.h"
 
//pins for connection
#define PIN_SDA p9
#define PIN_SCL p10
#define DEVICE_ADDR_BIT 0
//ref voltage
#define VDD_VOLTAGE 5.04
 
enum FREQ { FREQ_10HZ, FREQ_1HZ};
enum FORM { FORM_SQUARE, FORM_SIN};
 
/**
    Funciton: DAC_start
    Description: start generating the analog signal
*/
void DAC_start();
/**
    Funciton: DAC_stop
    Description: stop generating the analog signal
*/
void DAC_stop();
/**
    Funciton: DAC_generate
    Description: calculate the Vout accoding to the configuration and send command to DAC chip
*/
void DAC_generate();
/**
    Funciton: DAC_set
    Description: set the configuration( amplitude, frequency and form of the signal)
*/
void DAC_set(float range, enum FREQ freq, enum FORM form);
 
#endif