/* mbed USBMSD_Ram Library, for providing file access to SD cards
 * Copyright (c) 2008-2010, sford
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef USBMSD_RAM_H
#define USBMSD_RAM_H

#include "mbed.h"
#include "USBFileSystem.h"

class USBMSD_Ram : public USBFileSystem {
public:

   
    USBMSD_Ram();
    virtual int disk_initialize();
    virtual int _disk_write(const uint8_t * data, uint64_t block, uint8_t count);
    virtual int disk_read(uint8_t * data, uint64_t block, uint8_t count);    
    virtual int _disk_status();
    virtual int disk_sync();
    virtual uint64_t disk_sectors();
    
protected:
    int _status;
    char disk_image[512*16];

};

#endif
