#include "mbed.h"
#include "rtos.h"
#include "SimpleDMA.h"

DigitalOut led1(LED1);
SimpleDMA dma(0);
RawSerial pc(USBTX, USBRX);

void callback(void) {
    pc.printf("Callback!\r\n");
    }

void led_thread(void const *args) {
    
    while (true) {
        led1 = !led1;
        Thread::wait(300);
    }
}


int main() {
    printf("Start\r\n");
    
    printf("Use DMA to send 10 characters from buffer to buffer\r\n");
    printf("Then send them to UART0 (PC)\r\n");
    
    char characters[] = "abcdefgh\r\n";     //Characters we send
    char characters2[11];                   //Second buffer
    
    //Set source and destination, second argument is true since
    //we should run through both arrays
    dma.source(characters, true);
    dma.destination(characters2, true);
    //dma.attach(callback);
    //Start transfer of 10 characters
    dma.start(10);
    
    while(dma.isBusy());
    
    //Now to UART, enable DMA in UART, destination is now
    //a fixed address, so address pointer should not be incremented,
    //thus second argument is false. Also set trigger to UART0_RX.
    //This sends a new value to the UART as soon as it is possible
    #ifdef TARGET_LPC1768
    LPC_UART0->FCR |= 1<<3;
    dma.destination(&LPC_UART0->THR, false);
    #endif
    #ifdef TARGET_KL25Z
    UART0->C5 |= (1<<7) | (1<<5);
    dma.destination(&UART0->D, false);
    #endif
    dma.source(characters2, true);
    dma.trigger(Trigger_UART0_TX);

    dma.start(10);
    while(dma.isBusy());      
    
    printf("\r\n\nNow to show if it doesn't increment the address\r\n");
    printf("Also we attach a callback\r\n");
    dma.source(characters2, false);
    dma.attach(callback);
    dma.start(10);
    while(dma.isBusy());  

    
    printf("\r\n\nFinally we make it a loopback, and use RTOS\r\n");
    printf("The LED in another thread continues blinking while DMA send is busy\r\n");
    
    //Make a thread with low priority, to show main thread with DMA gives way to other thread while busy sending
    Thread thread(led_thread);
    thread.set_priority(osPriorityLow);
    
    #ifdef TARGET_LPC1768
    dma.source(&LPC_UART0->THR, false);
    #endif
    #ifdef TARGET_KL25Z
    dma.source(&UART0->D, false);
    #endif
    
    //Trigger is now the receiving on the UART
    dma.trigger(Trigger_UART0_RX);
    
    //dma.wait blocks the current Thread until finished while allowing other threads to run
    dma.wait(10);
    
    printf("\r\n\nFinished :-)\r\n");
    
    //Notice the LED doesn't blink now, since this thread uses all resources in while(1)
    while(1);
}
