#ifndef SI114X_DEFS_H
#define SI114X_DEFS_H


#define SI114x_ADDRESS (0x60 << 1)

enum Si114x_reg { 
    REG_PART_ID = 0x00,
    REG_REV_ID,
    REG_SEQ_ID,
    REG_INT_CFG,
    REG_IRQ_ENABLE,
    REG_HW_KEY = 0x07,
    REG_MEAS_RATE0, REG_MEAS_RATE1,
    REG_PS_LED21 = 0x0F, REG_PS_LED3,
    REG_UCOEF0 = 0x13, REG_UCOEF1, REG_UCOEF2, REG_UCOEF3,
    REG_PARAM_WR,
    REG_COMMAND,
    REG_RESPONSE = 0x20,
    REG_IRQ_STATUS,
    REG_ALS_VIS_DATA0, REG_ALS_VIS_DATA1,
    REG_ALS_IR_DATA0, REG_ALS_IR_DATA1,
    REG_PS1_DATA0, REG_PS1_DATA1,
    REG_PS2_DATA0, REG_PS2_DATA1,
    REG_PS3_DATA0 = 0x2A, REG_PS3_DATA1,
    REG_UV_INDEX0, REG_UV_INDEX1,
    REG_PARAM_RD,
    REG_CHIP_STAT = 0x30,
    REG_ANA_IN_KEY = 0x3B
    };

enum Si114x_commands {
    CMD_PARAM_QUERY = 0x80,
    CMD_PARAM_SET = 0xA0,
    CMD_NOP = 0x00,
    CMD_RESET = 0x01,
    CMD_BUS_ADDRESS = 0x02,
    CMD_PS_FORCE = 0x05,
    CMD_GET_CAL = 0x12,
    CMD_ALS_FORCE = 0x06,
    CMD_PLSALS_FORCE = 0x07,
    CMD_PS_AUTO = 0x0D,
    CMD_ALS_AUTO = 0x0E,
    CMD_PSALS_AUTO = 0x0F
};

enum Si114x_ram_address {
    RAM_I2C_ADDR,
    RAM_CHLIST,
    RAM_PSLED12_SELECT,
    RAM_PSLED3_SELECT,
    RAM_PS_ENCODING,
    RAM_ALS_ENCODING,
    RAM_PS1_ADCMUX,
    RAM_PS2_ADCMUX,
    RAM_PS3_ADCMUX,
    RAM_PS_ADC_COUNTER,
    RAM_PS_ADC_GAIN,
    RAM_PS_ADC_MISC,
    RAM_RESERVED0,
    RAM_ALS_IR_ADCMUX,
    RAM_AUX_ADCMUX,
    RAM_ALS_VIS_ADC_COUNTER,
    RAM_ALS_VIS_ADC_GAIN,
    RAM_ALS_VIS_ADC_MISC,
    RAM_RESERVED1,
    RAM_RESERVED2,
    RAM_RESERVED3,
    RAM_LED_REC,
    RAM_IR_ADC_COUNTER,
    RAM_IR_ADC_GAIN,
    RAM_IR_ADC_MISC
};
    
    
#endif