/*
Compile this program and upload it to your Wi-Go2 board. On a serial terminal
program such as TeraTerm you can follow the progress.

After a succesfull it will have created a Wi-Go folder on your SD card,
in it is a text file with some text. You can verify on for example your computer
if it is there.


Note:
For some reason my SD-card refuses the first command, which is why the mkdir command
is included twice. I believe the issue is my SD-card and not the Wi-Go board. If your
SD-card behaves normal this extra command will not give you any problems. In case
you also have the same issue there will be some error messages printed on your
terminal. As long as it says "Finished" at the end the program completed 
succesfully.
*/

#include "mbed.h"
#include "SDFileSystem.h"
 
DigitalOut SD_EN(PTE3);                         // Enable signal for SD Card
DigitalIn SD_CardDetect(PTE2);                  // Card detect signal
SDFileSystem sd(PTD6, PTD7, PTB11, PTE5, "sd"); // The pinout on the Wi-Go2 module
 
int main() {
    SD_EN = 0;
    
    printf("Enter SD Card!\r\n");
    
    while(SD_CardDetect != 0);                  // Wait until card is detected
    
    SD_EN = 1;                                  // Enable SD Card, wait a bit to make sure SD card is properly inserted
    wait(1);
    
    printf("Card detected!\r\n");
    
    mkdir("/sd/Wi-Go", 0777);
    mkdir("/sd/Wi-Go", 0777);
    
    FILE *fp = fopen("/sd/Wi-Go/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n\r");
    }
    fprintf(fp, "Hello Wi-Go SD card!");
    fclose(fp); 
 
    printf("Finished :-) \r\n");
}
